package ch.netzwerg.chabis;

import com.google.common.collect.ImmutableList;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;

import static java.util.stream.Collectors.toList;

public final class WordGenerator {

    public static final List<String> A_WORDS = ImmutableList.of(
            "Aabee",
            "Aagoal",
            "Aahäueli",
            "Aaleggi",
            "Abfüärä",
            "Abgwöhnerli",
            "Abihäberli",
            "Absteller",
            "Äckägstabi",
            "Aegäschtä",
            "Ägerscht",
            "Aissä",
            "Aläböck",
            "Allmig",
            "Amädiisli",
            "Ampäs",
            "Äntä",
            "Ankä",
            "Arvälä",
            "Ateiggär",
            "Ätti"
    );
    public static final List<String> B_WORDS = ImmutableList.of(
            "Babä",
            "Baabeli",
            "Bääbi",
            "Bääggu",
            "Bäägu",
            "Baaräbli",
            "Bäbätsch",
            "Bädarä",
            "Baggu",
            "Balaari",
            "Bägu",
            "Bätti",
            "Bätziwasser",
            "Balä",
            "Ballottä",
            "Bänggu",
            "Bännä",
            "Bänz",
            "Bapf",
            "Bärädräck",
            "Bäramsle",
            "Barisol",
            "Bauälä",
            "Bauälädampf",
            "Beckäli",
            "Beiribüüzel",
            "Beiz",
            "Beizer",
            "Bajaderli",
            "Bettmümpfeli",
            "Bezgi",
            "Bhaltis",
            "Bhaupti",
            "Biäli",
            "Bibäli",
            "Bicht",
            "Biibäli",
            "Biig",
            "Bileet",
            "Bimpäli",
            "Binätsch",
            "Binggis",
            "Bisnacht",
            "Bissa",
            "Blaascht",
            "Blaatere",
            "Blätz",
            "Bläuäle",
            "Bliiberli",
            "Bliili",
            "Blootärä",
            "Blööterliwasser",
            "Bluäscht",
            "Blutzger",
            "Bobbi",
            "Bodäsurri",
            "Bolgä",
            "Bogähuäschtä",
            "Bölä",
            "Bölädünnä",
            "Bolagger",
            "Bollei",
            "Bongert",
            "Böögg",
            "Böölimaa",
            "Boppä",
            "Bowäärli",
            "Bozu",
            "Brachät",
            "Brägäl",
            "Branberi",
            "Branschli",
            "Bräntä",
            "Brätschgä",
            "Bräusi",
            "Brigultini",
            "Brittli",
            "Brofflä",
            "Brüällätsch",
            "Brügäli",
            "Brügel",
            "Brügi",
            "Brüüschärä",
            "Brüütli",
            "Bschiss",
            "Bschlegi",
            "Bschütti",
            "Bsetzi",
            "Bsetzistei",
            "Büäz",
            "Büäzer",
            "Buck",
            "Budig",
            "Bulgä",
            "Bumpär",
            "Buntänööri",
            "Bulscha",
            "Bummeli",
            "Bünzli",
            "Büppi",
            "Burdi",
            "Bürzäli",
            "Bürzi",
            "Buschi",
            "Büschlä",
            "Büsi",
            "Buttipfuschra",
            "Buttlä",
            "Bütschgi",
            "Büülä",
            "Büürli",
            "Buzzimumäl",
            "Bygger"
    );
    public static final List<String> C_WORDS = ImmutableList.of(
            "Chabis",
            "Chacheli",
            "Chädärätä",
            "Chäib",
            "Chappä",
            "Charscht",
            "Chäsnäpper",
            "Chatzä",
            "Chautsch",
            "Chäutsch",
            "Cheeri",
            "Chefä",
            "Chefi",
            "Chegelischüeler",
            "Cheib",
            "Cheli",
            "Chemp",
            "Cheschtänä",
            "Chettälä",
            "Chiibätterli",
            "Chiibis",
            "Chilälöchli",
            "Chilbi",
            "Chiltär",
            "Chischtä",
            "Chislig",
            "Chittel",
            "Chlaauä",
            "Chlapf",
            "Chlämmerli",
            "Chleck",
            "Chlefälä",
            "Chlööni",
            "Chlööpä",
            "Chlöpfer",
            "Chlöpfmoscht",
            "Chlöpfschiit",
            "Chlööpä",
            "Chlotz",
            "Chlübis",
            "Chluupärä",
            "Chlückerli",
            "Chlupf",
            "Chlüttär",
            "Chluuf",
            "Chlüürä",
            "Chnebel",
            "Chnelä",
            "Chnobli",
            "Chnödli",
            "Chnöpfli",
            "Chnörzli",
            "Chnötsch",
            "Chnüppu",
            "Chnuschti",
            "Chnüttel",
            "Chnuupäsaager",
            "Chöderlig",
            "Chöitsch",
            "Chölä",
            "Cholderi",
            "Chöötschäli",
            "Chrääzä",
            "Chräbel",
            "Chräbel",
            "Chrache",
            "Chräläli",
            "Chrampf",
            "Chrattä",
            "Chriäsi",
            "Chreispälä",
            "Chriis",
            "Chritz",
            "Chrömli",
            "Chromo",
            "Chröpfli",
            "Chröschpäli",
            "Chroslä",
            "Chrottäpösche",
            "Chrötter",
            "Chrott",
            "Chrückli",
            "Chrungälä",
            "Chrüsch",
            "Chrüsimüsi",
            "Chrusli",
            "Chrüüsch",
            "Chruutsiänä",
            "Chuächätrööli",
            "Chuänagel",
            "Chüäjer",
            "Chübelibüürzel",
            "Chuchichäschtli",
            "Chuderluuri",
            "Chügäli",
            "Chümichnüpfer",
            "Chüngel",
            "Chunscht",
            "Chürbis",
            "Chuttä",
            "Chuttäfäckä",
            "Chuttlä",
            "Chüttenä",
            "Chutschi",
            "Chuttläputzätä",
            "Chuuschtofä",
            "Chuzämischt"
    );
    public static final List<String> D_WORDS = ImmutableList.of(
            "Dächlichappä",
            "Dachchännel",
            "Dädi",
            "Dampfi",
            "Dänkäli",
            "Dili",
            "Dolä",
            "Döller",
            "Doochä",
            "Dopleps",
            "Dotsch",
            "Dotteli",
            "Drämäl",
            "Dröbsli",
            "Druckätä",
            "Dündlä",
            "Durlips",
            "Düssu",
            "Dütschi",
            "Dyridäri"
    );
    public static final List<String> E_WORDS = ImmutableList.of(
            "Eignä",
            "Eieröhrli",
            "Eierschwamm",
            "Eiertätsch",
            "Eschtrich",
            "Etro" );

    public static final List<String> F_WORDS = ImmutableList.of(
            "Fagetta",
            "Fagettazyt",
            "Fassduube",
            "Faszäneetli",
            "Feischter",
            "Fekär",
            "Feumer",
            "Feutschä",
            "Finkä",
            "Finöggeli",
            "Fitzä",
            "Fladä",
            "Flaischchääs",
            "Fluumer",
            "Fländerli",
            "Flärä",
            "Flättärä",
            "Forgglä",
            "Frittä",
            "Fuässätä",
            "Fächtli",
            "Fäckä",
            "Fägnäscht",
            "Fägär",
            "Färlisou",
            "Fätzä",
            "Fötzäl",
            "Fötä",
            "Füdli",
            "Füdlibürger",
            "Füürstei"
    );

    public static final List<String> G_WORDS = ImmutableList.of(
            "Gacho",
            "Gadä",
            "Gaggalari",
            "Galööri",
            "Gampiross",
            "Garacho",
            "Garettä",
            "Gebsi",
            "Geburi",
            "Gellerettli",
            "Gellä",
            "Geltä",
            "Gertel",
            "Geufer",
            "Geuss",
            "Gflädär",
            "Gfrääsli",
            "Gfröörli",
            "Ghüderchübel",
            "Ghürsch",
            "Gibä",
            "Gigetschi",
            "Giggernillis",
            "Giireizi",
            "Giischter",
            "Giit",
            "Giiznäpper",
            "Gingg",
            "Ginnschett",
            "Ginöffel",
            "Girggäl",
            "Gischtär",
            "Gizi",
            "Giäl",
            "Gjätt",
            "Glettiisä",
            "Gloschli",
            "Gluggsi",
            "Gluggärä",
            "Glump",
            "Glunggä",
            "Gläck",
            "Gläpärä",
            "Glüggär",
            "Glünggi",
            "Glüschtälär",
            "Gnaadähüchlär",
            "Gnagi",
            "Gnuusch",
            "Gnäggi",
            "Goggwärgi",
            "Gonfi",
            "Goof",
            "Goofä",
            "Googgäli",
            "Goschä",
            "Gotsch",
            "Gottfridschtutz",
            "Grandbere",
            "Griitä",
            "Grind",
            "Grittibänz",
            "Grochsi",
            "Groggi",
            "Grunggäli",
            "Gruuperli",
            "Grätschä",
            "Grättimann",
            "Gräubschi",
            "Gröbschi",
            "Grööggu",
            "Grüezini",
            "Grüüsäl",
            "Gschiss",
            "Gschleik",
            "Gschlüder",
            "Gschmeus",
            "Gschnäpper",
            "Gschpill",
            "Gschpusi",
            "Gschpäändli",
            "Gschpüri",
            "Gschtrüpp",
            "Gschtungg",
            "Gschtältli",
            "Gschtürm",
            "Gschwellti",
            "Gsüchti",
            "Gufälä",
            "Gufärä",
            "Gugelfuär",
            "Gugerli",
            "Guggeerä",
            "Gugger",
            "Guggernälli",
            "Guggumerä",
            "Guggämusig",
            "Guggärschtütz",
            "Guggärziitli",
            "Gumel",
            "Gump",
            "Gumslä",
            "Guntä",
            "Gupf",
            "Guschteni",
            "Gusi",
            "Gutsch",
            "Gutschi",
            "Gutterä",
            "Guägä",
            "Guäzli",
            "Gvätterlizüüg",
            "Gwaggli",
            "Gwunder",
            "Gäldseckäl",
            "Gälleriebli",
            "Gänterli",
            "Gäzzi",
            "Göifer",
            "Göpäl",
            "Görbsi",
            "Güggi",
            "Güli",
            "Güllä",
            "Günschä",
            "Güsel",
            "Güselchübäl",
            "Güwettä",
            "Güüdelmentig",
            "Güüdälmäntig",
            "Güügs",
            "Güürbschi"
    );

    public static final List<String> H_WORDS = ImmutableList.of("Haag",
            "Haaghuuri",
            "Habasch",
            "Habä",
            "Hafäächääs",
            "Hampflä",
            "Hampäissi",
            "Handörgäli",
            "Hanf",
            "Harasse",
            "Hebi",
            "Heftli",
            "Hegel",
            "Heiti",
            "Helgä",
            "Helsätä",
            "Hemmliglunggi",
            "Hergöttli",
            "Heubeeri",
            "Heuel",
            "Heugümper",
            "Heuät",
            "Hezgi",
            "Hick",
            "Hiischi",
            "Hiiti",
            "Himmälgüügäli",
            "Hinderlig",
            "Hiubä",
            "Hizgi",
            "Hiäsiger",
            "Hochwasser",
            "Hodu",
            "Hoger",
            "Holder",
            "Holler",
            "Holloderi",
            "Hopzger",
            "Horner",
            "Hosli",
            "Hosälotteri",
            "Hotsch",
            "Hotschgufä",
            "Houdi",
            "Hudi",
            "Hudigääggälär",
            "Hudlä",
            "Hudäl",
            "Hudärä",
            "Hundsverlochätä",
            "Huppi",
            "Hurlibuäb",
            "Hurscht",
            "Huustagä",
            "Hälslig",
            "Hämli",
            "Hämpfäli",
            "Häpäräprägäl",
            "Häpöri",
            "Härdöpfel",
            "Hätzle",
            "Häuchel",
            "Häuptli",
            "Hääbi",
            "Häärd",
            "Höck",
            "Hötsch",
            "Höumi",
            "Hööptätä",
            "Höösi",
            "Hüberlig",
            "Hübäli",
            "Hüenervogel",
            "Hültschä",
            "Hültschägummäl",
            "Hünti",
            "Hüntschi",
            "Hürbi",
            "Hüsli",
            "Hüttä",
            "Hüänerhuut" );

    public static final List<String> I_WORDS = ImmutableList.of("Ilge", "Imbi" );

    public static final List<String> J_WORDS = ImmutableList.of(
            "Joggel",
            "Juuchzer",
            "Jännär",
            "Jöggelichaschte",
            "Jüntli"
    );

    public static final List<String> K_WORDS = ImmutableList.of(
            "Kischtär",
            "Komodä",
            "Kremänzer",
            "Kroki",
            "Kummet",
            "Kundiktör",
            "Köhlä",
            "Kösi"
    );

    public static final List<String> L_WORDS = ImmutableList.of(
            "Laabata",
            "Laarvä",
            "Lafäri",
            "Landjäger",
            "Lappi",
            "Latschi",
            "Laueri",
            "Laui",
            "Laväri",
            "Legoorä",
            "Lilachä",
            "Lismär",
            "Loobä",
            "Looschä",
            "Lotteri",
            "Luftibus",
            "Luschä",
            "Luuser",
            "Luuszapfä",
            "Lädi",
            "Lämpä",
            "Lätsch",
            "Läubi",
            "Läufterli",
            "Löcherbecki",
            "Löffäl",
            "Löli",
            "Lüürlibrüe"
    );

    public static final List<String> M_WORDS = ImmutableList.of(
            "Maad",
            "Maanu",
            "Magerlieni",
            "Magusil",
            "Maitli",
            "Malafiz",
            "Malun",
            "Manzälä",
            "Manöggel",
            "Masel",
            "Mektig",
            "Melchterli",
            "Mertel",
            "Migglä",
            "Minggis",
            "Mischmasch",
            "Mischt",
            "Mitli",
            "Mockä",
            "Modi",
            "Moltagig",
            "Montärä",
            "Moorä",
            "Moscht",
            "Moswey",
            "Mosä",
            "Moudi",
            "Moutschi",
            "Muesueli",
            "Mugerli",
            "Mungg",
            "Muni",
            "Mutschli",
            "Mutz",
            "Mutzä",
            "Muuloorgälä",
            "Muälä",
            "Muäma",
            "Mäiä",
            "Mäiäriisli",
            "Mäudi",
            "Mödäli",
            "Möff",
            "Möödäli",
            "Mümpfäli",
            "Müntschi",
            "Mürgu",
            "Müüs"
    );

    public static final List<String> N_WORDS = ImmutableList.of(
            "Nagwer",
            "Nani",
            "Nastüechli",
            "Nauggi",
            "Nauschlä",
            "Nedli",
            "Neni",
            "Nepot",
            "Niggäl",
            "Niidlä",
            "Niänenüüteli",
            "Nobisser",
            "Noggä",
            "Noppärä",
            "Nudäli",
            "Nuggi",
            "Nunni",
            "Nuuschäli",
            "Näggel",
            "Näll",
            "Näscht",
            "Näädlig",
            "Nüschäl",
            "Nüüteli"
    );

    public static final List<String> O_WORDS = ImmutableList.of("Obenigadä", "Oelstiirzli", "Ordinäri" );

    public static final List<String> P_WORDS = ImmutableList.of(
            "Paggu",
            "Pajass",
            "Palka",
            "Palota",
            "Panasch",
            "Pandur",
            "Paringäl",
            "Perron",
            "Pfeuk",
            "Pfiffoltärä",
            "Pfiffäbibi",
            "Pfifouter",
            "Pflotsch",
            "Pflutärä",
            "Pfnüsel",
            "Pfnüsäl",
            "Pfupf",
            "Pfuschi",
            "Pfuus",
            "Pfyffäli",
            "Pfätana",
            "Pfüderi",
            "Pfünderli",
            "Pfüüsi",
            "Pfüüsli",
            "Piggee",
            "Pinätsch",
            "Plaggeischt",
            "Plagööri",
            "Plaudäri",
            "Plausch",
            "Plegär",
            "Plofi",
            "Plutzgär",
            "Pläschär",
            "Plättli",
            "Plätz",
            "Plätzli",
            "Plütschi",
            "Pontenöri",
            "Poor",
            "Poppi",
            "Portmonee",
            "Poschettli",
            "Potschambär",
            "Pottaschä",
            "Prattig",
            "Preusivogel",
            "Pulschä",
            "Pumper",
            "Pumpi",
            "Pöschtler",
            "Pöötätärli",
            "Pülferli",
            "Pünt"
    );

    public static final List<String> Q_WORDS = ImmutableList.of(
            "Quaaki",
            "Quadradsploderi",
            "Quaksalber",
            "Quärtli"
    );

    public static final List<String> R_WORDS = ImmutableList.of(
            "Rafä",
            "Rampas",
            "Randä",
            "Rank",
            "Ranzä",
            "Ranzäpfiife",
            "Rappäschpalter",
            "Ratzmuus",
            "Rauft",
            "Reckholder",
            "Ribel",
            "Riibiisä",
            "Riitigampfi",
            "Riitiseili",
            "Riitschuäl",
            "Rossbollä",
            "Rosschopf",
            "Rufä",
            "Rundumäli",
            "Rung",
            "Rungglä",
            "Rungguuserli",
            "Rupf",
            "Ruäch",
            "Rämschala",
            "Räppli",
            "Rätschbäsi",
            "Rääbä",
            "Rääf",
            "Räävel",
            "Rüfi",
            "Rümä",
            "Rüäbli"
    );

    public static final List<String> S_WORDS = ImmutableList.of(
            "Salaathäuptli",
            "Samichlaus",
            "Schaalä",
            "Schabziger",
            "Schafsekäl",
            "Scharmützel",
            "Schassee",
            "Scheesä",
            "Scheesäwagä",
            "Scheichä",
            "Schelfärä",
            "Scheube",
            "Schiilädä",
            "Schiinär",
            "Schiitärbiig",
            "Schiner",
            "Schisshas",
            "Schlarpä",
            "Schlawiner",
            "Schlegel",
            "Schlick",
            "Schloff",
            "Schludäri",
            "Schlufi",
            "Schlunggi",
            "Schlupf",
            "Schluurggä",
            "Schlämpä",
            "Schläperä",
            "Schläufäli",
            "Schlötterlig",
            "Schlööf",
            "Schmalz",
            "Schmatz",
            "Schmichu",
            "Schmiisä",
            "Schmiär",
            "Schmutz",
            "Schmutzli",
            "Schnaaggä",
            "Schnauz",
            "Schneeschnüützi",
            "Schnoderbueb",
            "Schnorri",
            "Schnorä",
            "Schnuder",
            "Schnuderi",
            "Schnuderlumpä",
            "Schnudärgoof",
            "Schnurpfi",
            "Schnurrägiigä",
            "Schnurägiigä",
            "Schnuufär",
            "Schnäbäli",
            "Schnäderigäx",
            "Schnägg",
            "Schnäpf",
            "Schnäpper",
            "Schnügäl",
            "Scholä",
            "Schooss",
            "Schopf",
            "Schoppä",
            "Schornäggäli",
            "Schpaazä",
            "Schpargimäntä",
            "Schparz",
            "Schpatzig",
            "Schpeuz",
            "Schpiiggeli",
            "Schpiissä",
            "Schpinnhupälä",
            "Schpinoggel",
            "Schpriänzäl",
            "Schprung",
            "Schprutz",
            "Schpuntä",
            "Schranz",
            "Schrassäbütschgi",
            "Schrootär",
            "Schroppä",
            "Schtabellä",
            "Schtangä",
            "Schtick'l",
            "Schtierz",
            "Schtieränaug",
            "Schtift",
            "Schtiizä",
            "Schtiäragrind",
            "Schtorzä",
            "Schtragglä",
            "Schtriitzi",
            "Schtriäli",
            "Schtriämä",
            "Schtropf",
            "Schtrubuusätä",
            "Schträäl",
            "Schträäzär",
            "Schtuchä",
            "Schtumpä",
            "Schtunggis",
            "Schtuss",
            "Schtutz",
            "Schtägä",
            "Schtägäleenä",
            "Schtärnlifadä",
            "Schtöck",
            "Schtöckli",
            "Schtörgäli",
            "Schtütz",
            "Schudel",
            "Schuderhäuäl",
            "Schutzli",
            "Schwaab",
            "Schwafli",
            "Schwaldäri",
            "Schwetti",
            "Schwiiniggäl",
            "Schwiinigs",
            "Schwintä",
            "Schwirä",
            "Schwiärä",
            "Schwämm",
            "Schärmä",
            "Schöcheli",
            "Schöpfli",
            "Schüchlädär",
            "Schürger",
            "Schütti",
            "Schüübä",
            "Seechter",
            "Seich",
            "Seigl",
            "Seiliplampi",
            "Sekel",
            "Setzlig",
            "Sibäsiäch",
            "Sidian",
            "Sirach",
            "Siäch",
            "Siäneli",
            "Soigoof",
            "Souer",
            "Ständligurre",
            "Sudel",
            "Suff",
            "Suggi",
            "Summervogel",
            "Sunnäwirbl",
            "Supf",
            "Surrimurri",
            "Suurchabis",
            "Suurnippel",
            "Sägässä",
            "Säubluemä",
            "Säuniggel",
            "Söiniggel",
            "Süffäl",
            "Sürmel",
            "Süüfferli",
            "Süügwäsch",
            "Süüli"
    );

    public static final List<String> T_WORDS = ImmutableList.of(
            "Tablar",
            "Taburettli",
            "Tampa",
            "Taussä",
            "Teigaff",
            "Thek",
            "Titti",
            "Tocha",
            "Tolggä",
            "Tolä",
            "Tooräbueb",
            "Totsch",
            "Totz",
            "Triichlä",
            "Tritt",
            "Trottwar",
            "Truckä",
            "Trämel",
            "Trääsch",
            "Trümpi",
            "Tschiferä",
            "Tschingg",
            "Tschookä",
            "Tschooli",
            "Tschoope",
            "Tschuderheuel",
            "Tschugger",
            "Tschumpel",
            "Tschumpäli",
            "Tschutt",
            "Tschäpär",
            "Tschättärä",
            "Tschüüpi",
            "Tubl",
            "Tulung",
            "Turpe",
            "Tutsch",
            "Tutsuit",
            "Tuäch",
            "Tätsch",
            "Tätschburgär",
            "Tätschi",
            "Tätschmeischter",
            "Tääfeli",
            "Töffli",
            "Töggel",
            "Törggä",
            "Töz",
            "Tööplär",
            "Tööpä",
            "Tündlä",
            "Tünlä",
            "Tüpfi",
            "Tüpflischiisser",
            "Tütschi",
            "Tüürfallä"
    );
    public static final List<String> U_WORDS = ImmutableList.of(
            "Umbeisgi",
            "Unertiner",
            "Ungfell",
            "Untscha",
            "Uschtig",
            "Usägäld",
            "Usäschtuelätä",
            "Uufsteller",
            "Uufwäschluderä"
    );

    public static final List<String> V_WORDS = ImmutableList.of(
            "Velo",
            "Versuecherli",
            "Viärlig",
            "Vörteli",
            "Vörtuech"
    );

    public static final List<String> W_WORDS = ImmutableList.of(
            "Waggis",
            "Waggu",
            "Wank",
            "Watschä",
            "Webstübler",
            "Weggli",
            "Windä",
            "Wobi",
            "Wormasslä",
            "Wydlischryner",
            "Wädälä",
            "Wäjä",
            "Wälschland",
            "Wätterlainä",
            "Wösch",
            "Wümmät"
    );

    public static final List<String> X_WORDS = ImmutableList.of("Xundheit" );

    public static final List<String> Y_WORDS = ImmutableList.of("Ygrek" );

    public static final List<String> Z_WORDS = ImmutableList.of(
            "Zainä",
            "Zapfä",
            "Zappi",
            "Zaupf",
            "Zeiäli",
            "Ziischtig",
            "Zilätä",
            "Zimis",
            "Zinggä",
            "Zischgeli",
            "Zisäli",
            "Ziämeli",
            "Zmorgä",
            "Znüüni",
            "Zogglä",
            "Zolggä",
            "Zoobig",
            "Zottlä",
            "Zouggä",
            "Zvieri",
            "Zwetschgä",
            "Zwiäri",
            "Zwänzgerstückli",
            "Zältli",
            "Zännihaar",
            "Züchä",
            "Zückerli",
            "Zühä",
            "Züpfä"
    );

    public static final List<String> ALL_WORDS = ImmutableList.<String>builder().
            addAll(A_WORDS).
            addAll(B_WORDS).
            addAll(C_WORDS).
            addAll(D_WORDS).
            addAll(E_WORDS).
            addAll(F_WORDS).
            addAll(G_WORDS).
            addAll(H_WORDS).
            addAll(I_WORDS).
            addAll(J_WORDS).
            addAll(K_WORDS).
            addAll(L_WORDS).
            addAll(M_WORDS).
            addAll(N_WORDS).
            addAll(O_WORDS).
            addAll(P_WORDS).
            addAll(Q_WORDS).
            addAll(R_WORDS).
            addAll(S_WORDS).
            addAll(T_WORDS).
            addAll(U_WORDS).
            addAll(V_WORDS).
            addAll(W_WORDS).
            addAll(X_WORDS).
            addAll(Y_WORDS).
            addAll(Z_WORDS).build();

    private final Random random;

    public WordGenerator() {
        this(new Random());
    }

    public WordGenerator(Random random) {
        this.random = random;
    }

    public List<String> randomWords(int count) {
        return randomWords(this.random, count);
    }

    public List<String> uniqueRandomWords(int count) {
        return uniqueRandomWords(this.random, count);
    }

    public static List<String> randomWords(Random random, int count) {
        IntStream randomIndices = IntStream.generate(() -> random.nextInt(ALL_WORDS.size())).limit(count);
        return randomIndices.mapToObj(ALL_WORDS::get).collect(toList());
    }

    public static List<String> uniqueRandomWords(Random random, int count) {
        if (count >= ALL_WORDS.size()) {
            throw new IllegalArgumentException("Can maximally return " + ALL_WORDS.size() + " unique words" );
        } else if (count <= 0) {
            return Collections.emptyList();
        } else {
            List<String> words = new ArrayList<>(ALL_WORDS);
            Collections.shuffle(words, random);
            return words.subList(0, count);
        }
    }

}