/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.junit;

import ch.leadrian.stubr.core.Stubber;
import ch.leadrian.stubr.core.StubbingSite;
import ch.leadrian.stubr.junit.ParameterResolverStubbingSite;
import ch.leadrian.stubr.junit.StubberFactory;
import ch.leadrian.stubr.junit.annotation.Stub;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public final class Stubr
implements BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private final StubberFactory stubberFactory = new StubberFactory();
    private Stubber stubber;

    public void beforeEach(ExtensionContext context) {
        this.stubber = this.stubberFactory.create(context);
    }

    public void afterEach(ExtensionContext context) {
        this.stubber = null;
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.stubber != null && this.isAnnotatedWithStub(parameterContext.getParameter());
    }

    private boolean isAnnotatedWithStub(AnnotatedElement element) {
        if (element.isAnnotationPresent(Stub.class)) {
            return true;
        }
        return Arrays.stream(element.getAnnotations()).map(Annotation::annotationType).anyMatch(this::isAnnotatedWithStub);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Type parameterizedType = parameterContext.getParameter().getParameterizedType();
        ParameterResolverStubbingSite site = new ParameterResolverStubbingSite(parameterContext, extensionContext);
        return this.stubber.stub(parameterizedType, (StubbingSite)site);
    }
}

