/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.junit;

import ch.leadrian.stubr.core.Stubber;
import ch.leadrian.stubr.core.StubberBuilder;
import ch.leadrian.stubr.core.StubbingStrategy;
import ch.leadrian.stubr.junit.ExtensionContexts;
import ch.leadrian.stubr.junit.annotation.Include;
import ch.leadrian.stubr.junit.annotation.StubWith;
import ch.leadrian.stubr.junit.annotation.StubberBaseline;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;

final class StubberFactory {
    StubberFactory() {
    }

    Stubber create(ExtensionContext context) {
        List<ExtensionContext> contexts = ExtensionContexts.walk(context).collect(Collectors.toList());
        StubberBuilder builder = this.getStubberBuilder(contexts);
        this.getStubbers(context, contexts).forEach(arg_0 -> ((StubberBuilder)builder).include(arg_0));
        this.getStubbingStrategies(context, contexts).forEach(arg_0 -> ((StubberBuilder)builder).stubWith(arg_0));
        return builder.build();
    }

    private StubberBuilder getStubberBuilder(List<ExtensionContext> contexts) {
        return ExtensionContexts.getAnnotations(StubberBaseline.class, contexts).findFirst().map(StubberBaseline::value).orElse(StubberBaseline.Variant.DEFAULT).getBuilder();
    }

    private Stream<Stubber> getStubbers(ExtensionContext context, List<ExtensionContext> contexts) {
        return ExtensionContexts.getAnnotations(Include.class, Lists.reverse(contexts)).map(Include::value).flatMap(Arrays::stream).map(this::newInstance).flatMap(provider -> provider.getStubbers(context).stream());
    }

    private Stream<? extends StubbingStrategy> getStubbingStrategies(ExtensionContext context, List<ExtensionContext> contexts) {
        return ExtensionContexts.getAnnotations(StubWith.class, Lists.reverse(contexts)).map(StubWith::value).flatMap(Arrays::stream).map(this::newInstance).flatMap(provider -> provider.getStubbingStrategies(context).stream());
    }

    private <T> T newInstance(Class<T> clazz) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

