/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.core.strategy;

import ch.leadrian.stubr.core.Matcher;
import ch.leadrian.stubr.core.StubbingContext;
import ch.leadrian.stubr.core.StubbingStrategy;
import ch.leadrian.stubr.core.matcher.Matchers;
import ch.leadrian.stubr.core.strategy.ArrayStubbingStrategy;
import ch.leadrian.stubr.core.strategy.CollectionStubbingStrategy;
import ch.leadrian.stubr.core.strategy.ConditionalStubbingStrategy;
import ch.leadrian.stubr.core.strategy.ConstantValueStubbingStrategy;
import ch.leadrian.stubr.core.strategy.ConstructorStubbingStrategy;
import ch.leadrian.stubr.core.strategy.DefaultValueStubbingStrategy;
import ch.leadrian.stubr.core.strategy.EnumValueStubbingStrategy;
import ch.leadrian.stubr.core.strategy.FactoryMethodStubbingStrategy;
import ch.leadrian.stubr.core.strategy.ImplementationStubbingStrategy;
import ch.leadrian.stubr.core.strategy.MapStubbingStrategy;
import ch.leadrian.stubr.core.strategy.NullValueStubbingStrategy;
import ch.leadrian.stubr.core.strategy.OptionalStubbingMode;
import ch.leadrian.stubr.core.strategy.ProxyStubbingStrategy;
import ch.leadrian.stubr.core.strategy.StubValueSupplier;
import ch.leadrian.stubr.core.strategy.StubberStubbingStrategy;
import ch.leadrian.stubr.core.strategy.SuppliedValueStubbingStrategy;
import ch.leadrian.stubr.core.type.TypeLiteral;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;

public final class StubbingStrategies {
    private static final List<StubbingStrategy> EMPTY_DEFAULT_COLLECTIONS = StubbingStrategies.defaultCollections(0);
    private static final List<StubbingStrategy> COMMON_DEFAULT_VALUES = ImmutableList.builder().add((Object)StubbingStrategies.constantValue(new Object())).add((Object)StubbingStrategies.constantValue("")).add((Object)StubbingStrategies.constantValue(CharSequence.class, "")).add((Object)StubbingStrategies.constantValue(Number.class, Integer.valueOf(0))).add((Object)StubbingStrategies.constantValue(BigDecimal.ZERO)).add((Object)StubbingStrategies.constantValue(BigInteger.ZERO)).add((Object)StubbingStrategies.constantValue(LocalDate.of(1970, 1, 1))).add((Object)StubbingStrategies.constantValue(LocalTime.of(0, 0, 0))).add((Object)StubbingStrategies.constantValue(LocalDateTime.of(1970, 1, 1, 0, 0, 0))).add((Object)StubbingStrategies.constantValue(OffsetDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC))).add((Object)StubbingStrategies.constantValue(ZonedDateTime.of(1970, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC))).add((Object)StubbingStrategies.constantValue(Instant.EPOCH)).add((Object)StubbingStrategies.constantValue(Locale.GERMANY)).add((Object)StubbingStrategies.constantValue(OptionalDouble.empty())).add((Object)StubbingStrategies.constantValue(OptionalInt.empty())).add((Object)StubbingStrategies.constantValue(OptionalLong.empty())).add((Object)StubbingStrategies.constantValue(UUID.fromString("123e4567-e89b-12d3-a456-556642440000"))).build();

    private StubbingStrategies() {
    }

    public static StubbingStrategy array(ToIntFunction<? super StubbingContext> arraySize) {
        return new ArrayStubbingStrategy(arraySize);
    }

    public static StubbingStrategy array(int arraySize) {
        return StubbingStrategies.array(context -> arraySize);
    }

    public static StubbingStrategy array() {
        return StubbingStrategies.array(0);
    }

    public static <T extends Collection> StubbingStrategy collection(Class<T> collectionClass, Function<List<Object>, ? extends T> collectionFactory, ToIntFunction<? super StubbingContext> collectionSize) {
        return new CollectionStubbingStrategy<T>(collectionClass, collectionFactory, collectionSize);
    }

    public static <T extends Collection> StubbingStrategy collection(Class<T> collectionClass, Function<List<Object>, ? extends T> collectionFactory, int collectionSize) {
        return StubbingStrategies.collection(collectionClass, collectionFactory, context -> collectionSize);
    }

    public static <T extends Collection> StubbingStrategy collection(Class<T> collectionClass, Supplier<? extends T> collectionFactory) {
        Objects.requireNonNull(collectionFactory, "collectionFactory");
        return StubbingStrategies.collection(collectionClass, (List<Object> values) -> (Collection)collectionFactory.get(), 0);
    }

    public static StubbingStrategy conditional(StubbingStrategy delegate, Matcher<? super Type> typeMatcher) {
        return new ConditionalStubbingStrategy(delegate, typeMatcher);
    }

    public static List<StubbingStrategy> defaultCollections(ToIntFunction<? super StubbingContext> size) {
        return ImmutableList.builder().add((Object)StubbingStrategies.collection(Collection.class, ArrayList::new, size)).add((Object)StubbingStrategies.collection(List.class, ArrayList::new, size)).add((Object)StubbingStrategies.collection(ArrayList.class, ArrayList::new, size)).add((Object)StubbingStrategies.collection(Vector.class, Vector::new, size)).add((Object)StubbingStrategies.collection(Queue.class, LinkedList::new, size)).add((Object)StubbingStrategies.collection(LinkedList.class, LinkedList::new, size)).add((Object)StubbingStrategies.collection(Deque.class, ArrayDeque::new, size)).add((Object)StubbingStrategies.collection(Set.class, HashSet::new, size)).add((Object)StubbingStrategies.collection(HashSet.class, HashSet::new, size)).add((Object)StubbingStrategies.collection(LinkedHashSet.class, LinkedHashSet::new, size)).add((Object)StubbingStrategies.collection(SortedSet.class, TreeSet::new, size)).add((Object)StubbingStrategies.collection(NavigableSet.class, TreeSet::new, size)).add((Object)StubbingStrategies.collection(TreeSet.class, TreeSet::new, size)).add((Object)StubbingStrategies.collection(ConcurrentLinkedQueue.class, ConcurrentLinkedQueue::new, size)).add((Object)StubbingStrategies.collection(ConcurrentLinkedDeque.class, ConcurrentLinkedDeque::new, size)).add((Object)StubbingStrategies.collection(ConcurrentSkipListSet.class, ConcurrentSkipListSet::new, size)).add((Object)StubbingStrategies.map(Map.class, HashMap::new, size)).add((Object)StubbingStrategies.map(HashMap.class, HashMap::new, size)).add((Object)StubbingStrategies.map(LinkedHashMap.class, LinkedHashMap::new, size)).add((Object)StubbingStrategies.map(Hashtable.class, Hashtable::new, size)).add((Object)StubbingStrategies.map(SortedMap.class, TreeMap::new, size)).add((Object)StubbingStrategies.map(NavigableMap.class, TreeMap::new, size)).add((Object)StubbingStrategies.map(TreeMap.class, TreeMap::new, size)).add((Object)StubbingStrategies.map(ConcurrentMap.class, ConcurrentHashMap::new, size)).add((Object)StubbingStrategies.map(ConcurrentHashMap.class, ConcurrentHashMap::new, size)).add((Object)StubbingStrategies.map(ConcurrentNavigableMap.class, ConcurrentSkipListMap::new, size)).add((Object)StubbingStrategies.array(size)).build();
    }

    public static List<StubbingStrategy> defaultCollections(int size) {
        return StubbingStrategies.defaultCollections(context -> size);
    }

    public static List<StubbingStrategy> emptyDefaultCollections() {
        return EMPTY_DEFAULT_COLLECTIONS;
    }

    public static StubbingStrategy constantValue(Object value) {
        return new ConstantValueStubbingStrategy(value.getClass(), value);
    }

    public static <T> StubbingStrategy constantValue(Class<T> targetClass, T value) {
        return new ConstantValueStubbingStrategy(targetClass, value);
    }

    public static <T> StubbingStrategy constantValue(TypeLiteral<T> type, T value) {
        return new ConstantValueStubbingStrategy(type.getType(), value);
    }

    public static List<StubbingStrategy> commonConstantValues() {
        return COMMON_DEFAULT_VALUES;
    }

    public static StubbingStrategy constructor(Matcher<? super Constructor<?>> matcher) {
        return new ConstructorStubbingStrategy(matcher);
    }

    public static StubbingStrategy constructor() {
        return StubbingStrategies.constructor(Matchers.any());
    }

    public static StubbingStrategy defaultConstructor() {
        return StubbingStrategies.constructor((context, value) -> value.getParameterCount() == 0);
    }

    public static StubbingStrategy nonDefaultConstructor() {
        return StubbingStrategies.constructor((context, value) -> value.getParameterCount() > 0);
    }

    public static StubbingStrategy defaultValue() {
        return DefaultValueStubbingStrategy.INSTANCE;
    }

    public static StubbingStrategy enumValue() {
        return EnumValueStubbingStrategy.INSTANCE;
    }

    public static StubbingStrategy factoryMethod(Matcher<? super Method> matcher) {
        return new FactoryMethodStubbingStrategy(matcher);
    }

    public static StubbingStrategy factoryMethod() {
        return StubbingStrategies.factoryMethod(Matchers.any());
    }

    public static <T extends Map> StubbingStrategy map(Class<T> mapClass, Function<Map<Object, Object>, ? extends T> mapFactory, ToIntFunction<? super StubbingContext> mapSize) {
        return new MapStubbingStrategy<T>(mapClass, mapFactory, mapSize);
    }

    public static <T extends Map> StubbingStrategy map(Class<T> mapClass, Function<Map<Object, Object>, ? extends T> mapFactory, int mapSize) {
        return StubbingStrategies.map(mapClass, mapFactory, context -> mapSize);
    }

    public static <T extends Map> StubbingStrategy map(Class<T> mapClass, Supplier<? extends T> mapFactory) {
        Objects.requireNonNull(mapFactory, "mapFactory");
        return StubbingStrategies.map(mapClass, (Map<Object, Object> values) -> (Map)mapFactory.get(), 0);
    }

    public static StubbingStrategy nullValue() {
        return NullValueStubbingStrategy.INSTANCE;
    }

    public static StubbingStrategy optional(OptionalStubbingMode mode) {
        return mode.getStrategy();
    }

    public static StubbingStrategy optional() {
        return StubbingStrategies.optional(OptionalStubbingMode.EMPTY);
    }

    public static StubbingStrategy proxy(boolean cacheStubs) {
        return cacheStubs ? ProxyStubbingStrategy.CACHING : ProxyStubbingStrategy.NON_CACHING;
    }

    public static StubbingStrategy proxy() {
        return StubbingStrategies.proxy(true);
    }

    public static StubbingStrategy stubber() {
        return StubberStubbingStrategy.INSTANCE;
    }

    public static <T> StubbingStrategy suppliedValue(Class<T> type, StubValueSupplier<? extends T> valueSupplier) {
        return new SuppliedValueStubbingStrategy(type, valueSupplier);
    }

    public static <T> StubbingStrategy suppliedValue(Class<T> type, IntFunction<? extends T> valueSupplier) {
        Objects.requireNonNull(valueSupplier, "valueSupplier");
        return StubbingStrategies.suppliedValue(type, (StubbingContext context, int sequenceNumber) -> valueSupplier.apply(sequenceNumber));
    }

    public static <T> StubbingStrategy suppliedValue(Class<T> type, Supplier<? extends T> valueSupplier) {
        Objects.requireNonNull(valueSupplier, "valueSupplier");
        return StubbingStrategies.suppliedValue(type, (int sequenceNumber) -> valueSupplier.get());
    }

    public static <T> StubbingStrategy suppliedValue(TypeLiteral<T> typeLiteral, StubValueSupplier<? extends T> valueSupplier) {
        return new SuppliedValueStubbingStrategy(typeLiteral.getType(), valueSupplier);
    }

    public static <T> StubbingStrategy suppliedValue(TypeLiteral<T> typeLiteral, IntFunction<? extends T> valueSupplier) {
        Objects.requireNonNull(valueSupplier, "valueSupplier");
        return StubbingStrategies.suppliedValue(typeLiteral, (StubbingContext context, int sequenceNumber) -> valueSupplier.apply(sequenceNumber));
    }

    public static <T> StubbingStrategy suppliedValue(TypeLiteral<T> typeLiteral, Supplier<? extends T> valueSupplier) {
        Objects.requireNonNull(valueSupplier, "valueSupplier");
        return StubbingStrategies.suppliedValue(typeLiteral, (int sequenceNumber) -> valueSupplier.get());
    }

    public static List<StubbingStrategy> commonSuppliedValues() {
        return ImmutableList.builder().add((Object)StubbingStrategies.suppliedValue(AtomicInteger.class, () -> new AtomicInteger(0))).add((Object)StubbingStrategies.suppliedValue(AtomicBoolean.class, () -> new AtomicBoolean(false))).add((Object)StubbingStrategies.suppliedValue(AtomicLong.class, () -> new AtomicLong(0L))).add((Object)StubbingStrategies.suppliedValue(java.util.Date.class, () -> new java.util.Date(0L))).add((Object)StubbingStrategies.suppliedValue(Date.class, () -> new Date(0L))).build();
    }

    public static <T, U extends T> StubbingStrategy implementation(Class<T> targetClass, Class<U> implementationClass) {
        return new ImplementationStubbingStrategy(targetClass, implementationClass);
    }

    public static <T, U extends T> StubbingStrategy implementation(TypeLiteral<T> targetTypeLiteral, TypeLiteral<U> implementationTypeLiteral) {
        return new ImplementationStubbingStrategy(targetTypeLiteral.getType(), implementationTypeLiteral.getType());
    }

    public static <T, U extends T> StubbingStrategy implementation(TypeLiteral<T> targetTypeLiteral, Class<U> implementationClass) {
        return new ImplementationStubbingStrategy(targetTypeLiteral.getType(), implementationClass);
    }

    public static <T, U extends T> StubbingStrategy implementation(Class<T> targetClass, TypeLiteral<U> implementationTypeLiteral) {
        return new ImplementationStubbingStrategy(targetClass, implementationTypeLiteral.getType());
    }
}

