/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.core.strategy;

import ch.leadrian.stubr.core.StubbingContext;
import ch.leadrian.stubr.core.StubbingException;
import ch.leadrian.stubr.core.StubbingStrategy;
import ch.leadrian.stubr.core.type.TypeVisitor;
import ch.leadrian.stubr.core.type.Types;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public abstract class SimpleStubbingStrategy<T>
implements StubbingStrategy {
    @Override
    public boolean accepts(final StubbingContext context, Type type) {
        return TypeVisitor.accept(type, new TypeVisitor<Boolean>(){

            @Override
            public Boolean visit(Class<?> clazz) {
                return SimpleStubbingStrategy.this.acceptsClass(context, clazz);
            }

            @Override
            public Boolean visit(ParameterizedType parameterizedType) {
                return SimpleStubbingStrategy.this.acceptsParameterizedType(context, parameterizedType);
            }

            @Override
            public Boolean visit(WildcardType wildcardType) {
                return Types.getBound(wildcardType).filter(t -> TypeVisitor.accept(t, this)).isPresent();
            }

            @Override
            public Boolean visit(TypeVariable<?> typeVariable) {
                return false;
            }

            @Override
            public Boolean visit(GenericArrayType genericArrayType) {
                return false;
            }
        });
    }

    protected abstract boolean acceptsClass(StubbingContext var1, Class<?> var2);

    protected abstract boolean acceptsParameterizedType(StubbingContext var1, ParameterizedType var2);

    public T stub(final StubbingContext context, Type type) {
        return TypeVisitor.accept(type, new TypeVisitor<T>(){

            @Override
            public T visit(Class<?> clazz) {
                return SimpleStubbingStrategy.this.stubClass(context, clazz);
            }

            @Override
            public T visit(ParameterizedType parameterizedType) {
                return SimpleStubbingStrategy.this.stubParameterizedType(context, parameterizedType);
            }

            @Override
            public T visit(WildcardType wildcardType) {
                return Types.getBound(wildcardType).map(t -> TypeVisitor.accept(t, this)).orElseThrow(() -> new StubbingException(context.getSite(), wildcardType));
            }

            @Override
            public T visit(TypeVariable<?> typeVariable) {
                throw new StubbingException(context.getSite(), typeVariable);
            }

            @Override
            public T visit(GenericArrayType genericArrayType) {
                throw new StubbingException(context.getSite(), genericArrayType);
            }
        });
    }

    protected abstract T stubClass(StubbingContext var1, Class<?> var2);

    protected abstract T stubParameterizedType(StubbingContext var1, ParameterizedType var2);
}

