/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.core.strategy;

import ch.leadrian.stubr.core.Matcher;
import ch.leadrian.stubr.core.StubbingContext;
import ch.leadrian.stubr.core.StubbingException;
import ch.leadrian.stubr.core.StubbingSite;
import ch.leadrian.stubr.core.StubbingStrategy;
import ch.leadrian.stubr.core.site.MethodParameterStubbingSite;
import ch.leadrian.stubr.core.site.StubbingSites;
import ch.leadrian.stubr.core.type.Types;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

final class FactoryMethodStubbingStrategy
implements StubbingStrategy {
    private final Matcher<? super Method> methodMatcher;
    private final Map<Class<?>, Method> factoryMethodsByClass = new ConcurrentHashMap();

    FactoryMethodStubbingStrategy(Matcher<? super Method> methodMatcher) {
        Objects.requireNonNull(methodMatcher, "methodMatcher");
        this.methodMatcher = methodMatcher;
    }

    @Override
    public boolean accepts(StubbingContext context, Type type) {
        return this.getFactoryMethod(context, type).isPresent();
    }

    @Override
    public Object stub(StubbingContext context, Type type) {
        Method method = this.getFactoryMethod(context, type).orElseThrow(() -> new StubbingException("No matching factory method found", context.getSite(), type));
        Object[] parameterValues = this.stub(context, method);
        return this.invokeFactoryMethod(method, parameterValues);
    }

    private Object invokeFactoryMethod(Method method, Object[] parameterValues) {
        method.setAccessible(true);
        try {
            return method.invoke(null, parameterValues);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private Object[] stub(StubbingContext context, Method method) {
        return Arrays.stream(method.getParameters()).map(parameter -> this.stub(context, method, (Parameter)parameter)).toArray(Object[]::new);
    }

    private Object stub(StubbingContext context, Method method, Parameter parameter) {
        MethodParameterStubbingSite site = StubbingSites.methodParameter(context.getSite(), method, parameter);
        return context.getStubber().stub(parameter.getParameterizedType(), (StubbingSite)site);
    }

    private Optional<Method> getFactoryMethod(StubbingContext context, Type type) {
        return Types.getRawType(type).filter(this::isInstantiable).flatMap(rawType -> this.getFactoryMethod(context, (Class<?>)rawType));
    }

    private boolean isInstantiable(Class<?> clazz) {
        return !clazz.isPrimitive() && !clazz.isEnum() && !clazz.isInterface();
    }

    private Optional<Method> getFactoryMethod(StubbingContext context, Class<?> targetClass) {
        Method method = this.factoryMethodsByClass.computeIfAbsent(targetClass, c -> {
            List<Method> methods = this.getFactoryMethods(context, targetClass);
            if (methods.size() == 1) {
                return methods.get(0);
            }
            return null;
        });
        return Optional.ofNullable(method);
    }

    private List<Method> getFactoryMethods(StubbingContext context, Class<?> targetClass) {
        return Arrays.stream(targetClass.getDeclaredMethods()).filter(method -> !method.isSynthetic() && !Modifier.isPrivate(method.getModifiers()) && Modifier.isStatic(method.getModifiers())).filter(method -> this.canReturn((Method)method, targetClass)).filter(method -> this.methodMatcher.matches(context, (Method)method)).collect(Collectors.toList());
    }

    private boolean canReturn(Method method, Class<?> type) {
        return Types.getRawType(method.getGenericReturnType()).filter(clazz -> clazz.isAssignableFrom(type)).isPresent();
    }
}

