/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.core.strategy;

import ch.leadrian.stubr.core.Matcher;
import ch.leadrian.stubr.core.StubbingContext;
import ch.leadrian.stubr.core.StubbingStrategy;
import java.lang.reflect.Type;
import java.util.Objects;

final class ConditionalStubbingStrategy
implements StubbingStrategy {
    private final StubbingStrategy delegate;
    private final Matcher<? super Type> typeMatcher;

    ConditionalStubbingStrategy(StubbingStrategy delegate, Matcher<? super Type> typeMatcher) {
        Objects.requireNonNull(delegate, "delegate");
        Objects.requireNonNull(typeMatcher, "typeMatcher");
        this.delegate = delegate;
        this.typeMatcher = typeMatcher;
    }

    @Override
    public boolean accepts(StubbingContext context, Type type) {
        return this.typeMatcher.matches(context, type) && this.delegate.accepts(context, type);
    }

    @Override
    public Object stub(StubbingContext context, Type type) {
        return this.delegate.stub(context, type);
    }
}

