/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.core.strategy;

import ch.leadrian.stubr.core.StubbingContext;
import ch.leadrian.stubr.core.site.ParameterizedTypeStubbingSite;
import ch.leadrian.stubr.core.site.StubbingSites;
import ch.leadrian.stubr.core.strategy.SimpleStubbingStrategy;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

final class CollectionStubbingStrategy<T extends Collection>
extends SimpleStubbingStrategy<T> {
    private final Class<T> collectionClass;
    private final Function<List<Object>, ? extends T> collectionFactory;
    private final ToIntFunction<? super StubbingContext> collectionSize;

    CollectionStubbingStrategy(Class<T> collectionClass, Function<List<Object>, ? extends T> collectionFactory, ToIntFunction<? super StubbingContext> collectionSize) {
        Objects.requireNonNull(collectionClass, "collectionClass");
        Objects.requireNonNull(collectionFactory, "collectionFactory");
        Objects.requireNonNull(collectionSize, "collectionSize");
        this.collectionClass = collectionClass;
        this.collectionFactory = collectionFactory;
        this.collectionSize = collectionSize;
    }

    @Override
    protected boolean acceptsClass(StubbingContext context, Class<?> type) {
        return this.collectionClass == type && this.collectionSize.applyAsInt(context) == 0;
    }

    @Override
    protected boolean acceptsParameterizedType(StubbingContext context, ParameterizedType type) {
        return this.collectionClass == type.getRawType() && type.getActualTypeArguments().length == 1;
    }

    @Override
    protected T stubClass(StubbingContext context, Class<?> type) {
        return (T)((Collection)this.collectionFactory.apply(Collections.emptyList()));
    }

    @Override
    protected T stubParameterizedType(StubbingContext context, ParameterizedType type) {
        Type valueType = type.getActualTypeArguments()[0];
        ParameterizedTypeStubbingSite site = StubbingSites.parameterizedType(context.getSite(), type, 0);
        List values = IntStream.iterate(0, i -> i + 1).limit(this.collectionSize.applyAsInt(context)).mapToObj(i -> context.getStubber().stub(valueType, site)).collect(Collectors.toList());
        return (T)((Collection)this.collectionFactory.apply(values));
    }
}

