/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.core.matcher;

import ch.leadrian.stubr.core.Matcher;
import ch.leadrian.stubr.core.matcher.AnnotatedElementMatcher;
import ch.leadrian.stubr.core.matcher.AnnotationMatcher;
import ch.leadrian.stubr.core.matcher.ConstructorMatcher;
import ch.leadrian.stubr.core.matcher.ExecutableMatcher;
import ch.leadrian.stubr.core.matcher.MethodMatcher;
import ch.leadrian.stubr.core.matcher.ParameterMatcher;
import ch.leadrian.stubr.core.matcher.ParameterTypesMatcher;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;

public final class Matchers {
    private Matchers() {
    }

    public static <T extends Executable> Matcher<T> accepting(Class<?> ... parameterTypes) {
        return new ParameterTypesMatcher(parameterTypes);
    }

    public static <T extends AnnotatedElement> Matcher<T> annotatedWith(String annotationName) {
        return AnnotationMatcher.by(annotationName);
    }

    public static <T extends AnnotatedElement> Matcher<T> annotatedWith(Class<? extends Annotation> annotationType) {
        return AnnotationMatcher.by(annotationType);
    }

    public static <T extends AnnotatedElement> Matcher<T> annotatedWith(Annotation annotation) {
        return AnnotationMatcher.by(annotation);
    }

    public static <T> Matcher<T> annotatedSiteIs(Matcher<? super AnnotatedElement> delegate) {
        return new AnnotatedElementMatcher(delegate);
    }

    public static <T> Matcher<T> any() {
        return (context, value) -> true;
    }

    public static <T> Matcher<T> executableIs(Matcher<? super Executable> delegate) {
        return new ExecutableMatcher(delegate);
    }

    public static <T> Matcher<T> constructorIs(Matcher<? super Constructor<?>> delegate) {
        return new ConstructorMatcher(delegate);
    }

    public static <T> Matcher<T> methodIs(Matcher<? super Method> delegate) {
        return new MethodMatcher(delegate);
    }

    public static <T> Matcher<T> not(Matcher<T> matcher) {
        return matcher.negate();
    }

    public static <T extends AnnotatedElement> Matcher<T> nullable() {
        return Matchers.annotatedWith("Nullable");
    }

    public static <T extends AnnotatedElement> Matcher<T> nonNull() {
        return Matchers.annotatedWith("NotNull").or(Matchers.annotatedWith("NonNull")).or(Matchers.annotatedWith("Nonnull"));
    }

    public static <T> Matcher<T> parameterIs(Matcher<? super Parameter> delegate) {
        return new ParameterMatcher(delegate);
    }
}

