/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.core;

import ch.leadrian.stubr.core.Matcher;
import ch.leadrian.stubr.core.Result;
import ch.leadrian.stubr.core.Stubber;
import ch.leadrian.stubr.core.StubberBuilder;
import ch.leadrian.stubr.core.StubbingContext;
import ch.leadrian.stubr.core.StubbingStrategy;
import ch.leadrian.stubr.core.strategy.StubbingStrategies;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

final class StubberImpl
extends Stubber {
    private final List<StubbingStrategy> strategies;

    private StubberImpl(List<StubbingStrategy> strategies) {
        this.strategies = ImmutableList.copyOf(strategies);
    }

    @Override
    protected Result<?> tryToStub(Type type, StubbingContext context) {
        return this.strategies.stream().filter(strategy -> strategy.accepts(context, type)).map(strategy -> Result.success(strategy.stub(context, type))).findFirst().orElse(Result.failure());
    }

    static final class Builder
    implements StubberBuilder {
        private final List<Stubber> stubbers = new ArrayList<Stubber>();
        private final List<StubbingStrategy> strategies = new ArrayList<StubbingStrategy>();

        Builder() {
        }

        @Override
        public StubberBuilder include(Stubber stubber) {
            Objects.requireNonNull(stubber, "stubber");
            this.stubbers.add(0, stubber);
            return this;
        }

        @Override
        public StubberBuilder stubWith(StubbingStrategy strategy) {
            Objects.requireNonNull(strategy, "strategy");
            this.strategies.add(0, strategy);
            return this;
        }

        @Override
        public StubberBuilder stubWith(StubbingStrategy strategy, Matcher<? super Type> matcher) {
            Objects.requireNonNull(strategy, "strategy");
            Objects.requireNonNull(matcher, "matcher");
            return this.stubWith(StubbingStrategies.conditional(strategy, matcher));
        }

        @Override
        public StubberBuilder stubWith(Iterable<? extends StubbingStrategy> strategies) {
            Objects.requireNonNull(strategies, "strategies");
            strategies.forEach(this::stubWith);
            return this;
        }

        @Override
        public StubberBuilder stubWith(Iterable<? extends StubbingStrategy> strategies, Matcher<? super Type> matcher) {
            Objects.requireNonNull(strategies, "strategies");
            Objects.requireNonNull(matcher, "matcher");
            strategies.forEach(strategy -> this.stubWith((StubbingStrategy)strategy, matcher));
            return this;
        }

        @Override
        public StubberBuilder stubWith(StubbingStrategy ... strategies) {
            Objects.requireNonNull(strategies, "strategies");
            this.stubWith(Arrays.asList(strategies));
            return this;
        }

        @Override
        public Stubber build() {
            StubberImpl builtStubber = new StubberImpl(this.strategies);
            if (this.stubbers.isEmpty()) {
                return builtStubber;
            }
            ArrayList<Stubber> stubberComposition = new ArrayList<Stubber>(this.stubbers);
            stubberComposition.add(0, builtStubber);
            return Stubber.compose(stubberComposition);
        }
    }
}

