/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.core;

import ch.leadrian.stubr.core.Result;
import ch.leadrian.stubr.core.Stubber;
import ch.leadrian.stubr.core.StubbingContext;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;

final class CompositeStubber
extends Stubber {
    private final List<Stubber> stubbers;

    CompositeStubber(List<? extends Stubber> stubbers) {
        Objects.requireNonNull(stubbers, "stubbers");
        this.stubbers = ImmutableList.copyOf(stubbers);
    }

    @Override
    protected Result<?> tryToStub(Type type, StubbingContext context) {
        return this.stubbers.stream().map(stubber -> stubber.tryToStub(type, context)).filter(Result::isSuccess).findFirst().orElse(Result.failure());
    }
}

