/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.core.strategy;

import ch.leadrian.stubr.core.Result;
import ch.leadrian.stubr.core.StubbingContext;
import ch.leadrian.stubr.core.StubbingSite;
import ch.leadrian.stubr.core.site.ParameterizedTypeStubbingSite;
import ch.leadrian.stubr.core.site.StubbingSites;
import ch.leadrian.stubr.core.strategy.SimpleStubbingStrategy;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;

abstract class OptionalStubbingStrategy
extends SimpleStubbingStrategy<Optional<Object>> {
    static final OptionalStubbingStrategy EMPTY = new Empty();
    static final OptionalStubbingStrategy PRESENT = new Present();
    static final OptionalStubbingStrategy PRESENT_IF_POSSIBLE = new PresentIfPossible();

    private OptionalStubbingStrategy() {
    }

    @Override
    protected boolean acceptsClass(StubbingContext context, Class<?> type) {
        return Optional.class == type && this.isEmptyAllowed();
    }

    @Override
    protected boolean acceptsParameterizedType(StubbingContext context, ParameterizedType parameterizedType) {
        return Optional.class == parameterizedType.getRawType();
    }

    @Override
    protected Optional<Object> stubClass(StubbingContext context, Class<?> type) {
        return Optional.empty();
    }

    @Override
    protected Optional<Object> stubParameterizedType(StubbingContext context, ParameterizedType type) {
        return this.stubOptional(context, type);
    }

    protected abstract Optional<Object> stubOptional(StubbingContext var1, ParameterizedType var2);

    protected abstract boolean isEmptyAllowed();

    private static final class PresentIfPossible
    extends AbstractPresent {
        private PresentIfPossible() {
        }

        @Override
        protected Optional<Object> stubOptional(StubbingContext context, StubbingSite site, Type valueType) {
            Result<?> result = context.getStubber().tryToStub(valueType, site);
            if (result.isSuccess()) {
                return Optional.ofNullable(result.getValue());
            }
            return Optional.empty();
        }

        @Override
        protected boolean isEmptyAllowed() {
            return true;
        }
    }

    private static final class Present
    extends AbstractPresent {
        private Present() {
        }

        @Override
        protected Optional<Object> stubOptional(StubbingContext context, StubbingSite site, Type valueType) {
            return Optional.ofNullable(context.getStubber().stub(valueType, site));
        }

        @Override
        protected boolean isEmptyAllowed() {
            return false;
        }
    }

    private static abstract class AbstractPresent
    extends OptionalStubbingStrategy {
        private AbstractPresent() {
        }

        @Override
        protected final Optional<Object> stubOptional(StubbingContext context, ParameterizedType type) {
            ParameterizedTypeStubbingSite site = StubbingSites.parameterizedType(context.getSite(), type, 0);
            Type valueType = type.getActualTypeArguments()[0];
            return this.stubOptional(context, site, valueType);
        }

        protected abstract Optional<Object> stubOptional(StubbingContext var1, StubbingSite var2, Type var3);
    }

    private static final class Empty
    extends OptionalStubbingStrategy {
        private Empty() {
        }

        @Override
        protected Optional<Object> stubOptional(StubbingContext context, ParameterizedType type) {
            return Optional.empty();
        }

        @Override
        protected boolean isEmptyAllowed() {
            return true;
        }
    }
}

