/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.core.strategy;

import ch.leadrian.stubr.core.StubbingContext;
import ch.leadrian.stubr.core.site.ParameterizedTypeStubbingSite;
import ch.leadrian.stubr.core.site.StubbingSites;
import ch.leadrian.stubr.core.strategy.SimpleStubbingStrategy;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;

final class MapStubbingStrategy<T extends Map>
extends SimpleStubbingStrategy<T> {
    private final Class<T> mapClass;
    private final Function<Map<Object, Object>, ? extends T> mapFactory;
    private final ToIntFunction<? super StubbingContext> mapSize;

    MapStubbingStrategy(Class<T> mapClass, Function<Map<Object, Object>, ? extends T> mapFactory, ToIntFunction<? super StubbingContext> mapSize) {
        Objects.requireNonNull(mapClass, "mapClass");
        Objects.requireNonNull(mapFactory, "mapFactory");
        Objects.requireNonNull(mapSize, "mapSize");
        this.mapClass = mapClass;
        this.mapFactory = mapFactory;
        this.mapSize = mapSize;
    }

    @Override
    protected boolean acceptsClass(StubbingContext context, Class<?> type) {
        return this.mapClass == type && this.mapSize.applyAsInt(context) == 0;
    }

    @Override
    protected boolean acceptsParameterizedType(StubbingContext context, ParameterizedType type) {
        return this.mapClass == type.getRawType() && type.getActualTypeArguments().length == 2;
    }

    @Override
    protected T stubClass(StubbingContext context, Class<?> type) {
        return (T)((Map)this.mapFactory.apply(Collections.emptyMap()));
    }

    @Override
    protected T stubParameterizedType(StubbingContext context, ParameterizedType type) {
        Type keyType = type.getActualTypeArguments()[0];
        Type valueType = type.getActualTypeArguments()[1];
        ParameterizedTypeStubbingSite keySite = StubbingSites.parameterizedType(context.getSite(), type, 0);
        ParameterizedTypeStubbingSite valueSite = StubbingSites.parameterizedType(context.getSite(), type, 1);
        int size = this.mapSize.applyAsInt(context);
        HashMap values = new HashMap(size);
        IntStream.iterate(0, i -> i + 1).limit(size).forEach(i -> {
            Object key = context.getStubber().stub(keyType, keySite);
            Object value = context.getStubber().stub(valueType, valueSite);
            values.put(key, value);
        });
        return (T)((Map)this.mapFactory.apply(values));
    }
}

