/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.core.site;

import ch.leadrian.stubr.core.StubbingSite;
import ch.leadrian.stubr.core.site.ArrayStubbingSite;
import ch.leadrian.stubr.core.site.ConstructorParameterStubbingSite;
import ch.leadrian.stubr.core.site.MethodParameterStubbingSite;
import ch.leadrian.stubr.core.site.MethodReturnValueStubbingSite;
import ch.leadrian.stubr.core.site.ParameterizedTypeStubbingSite;
import ch.leadrian.stubr.core.site.UnknownStubbingSite;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;

public final class StubbingSites {
    private StubbingSites() {
    }

    public static ArrayStubbingSite array(StubbingSite parent, Class<?> componentType) {
        return new ArrayStubbingSite(parent, componentType);
    }

    public static ConstructorParameterStubbingSite constructorParameter(StubbingSite parent, Constructor<?> constructor, Parameter parameter) {
        int index = Arrays.asList(constructor.getParameters()).indexOf(parameter);
        if (index == -1) {
            throw new IllegalArgumentException(String.format("%s is not a parameter of %s", parameter, constructor));
        }
        return new ConstructorParameterStubbingSite(parent, constructor, parameter, index);
    }

    public static ConstructorParameterStubbingSite constructorParameter(StubbingSite parent, Constructor<?> constructor, int parameterIndex) {
        return new ConstructorParameterStubbingSite(parent, constructor, constructor.getParameters()[parameterIndex], parameterIndex);
    }

    public static MethodParameterStubbingSite methodParameter(StubbingSite parent, Method method, Parameter parameter) {
        int index = Arrays.asList(method.getParameters()).indexOf(parameter);
        if (index == -1) {
            throw new IllegalArgumentException(String.format("%s is not a parameter of %s", parameter, method));
        }
        return new MethodParameterStubbingSite(parent, method, parameter, index);
    }

    public static MethodParameterStubbingSite methodParameter(StubbingSite parent, Method method, int parameterIndex) {
        return new MethodParameterStubbingSite(parent, method, method.getParameters()[parameterIndex], parameterIndex);
    }

    public static MethodReturnValueStubbingSite methodReturnValue(StubbingSite parent, Method method) {
        return new MethodReturnValueStubbingSite(parent, method);
    }

    public static ParameterizedTypeStubbingSite parameterizedType(StubbingSite parent, ParameterizedType type, int typeArgumentIndex) {
        return new ParameterizedTypeStubbingSite(parent, type, typeArgumentIndex);
    }

    public static UnknownStubbingSite unknown() {
        return UnknownStubbingSite.INSTANCE;
    }
}

