/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.core.matcher;

import ch.leadrian.stubr.core.Matcher;
import ch.leadrian.stubr.core.StubbingContext;
import ch.leadrian.stubr.core.type.Types;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Objects;

final class ParameterTypesMatcher<T extends Executable>
implements Matcher<T> {
    private final List<Class<?>> parameterTypes;

    ParameterTypesMatcher(Class<?> ... parameterTypes) {
        Objects.requireNonNull(parameterTypes, "parameterTypes");
        this.parameterTypes = ImmutableList.copyOf((Object[])parameterTypes);
    }

    @Override
    public boolean matches(StubbingContext context, T value) {
        Parameter[] parameters = ((Executable)value).getParameters();
        if (parameters.length != this.parameterTypes.size()) {
            return false;
        }
        for (int i = 0; i < this.parameterTypes.size(); ++i) {
            if (this.isAssignable(parameters[i], this.parameterTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isAssignable(Parameter parameter, Class<?> type) {
        return Types.getRawType(parameter.getParameterizedType()).filter(clazz -> clazz.isAssignableFrom(type)).isPresent();
    }
}

