/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.core.strategy;

import ch.leadrian.stubr.core.StubbingContext;
import ch.leadrian.stubr.core.StubbingException;
import ch.leadrian.stubr.core.StubbingStrategy;
import ch.leadrian.stubr.core.type.Types;
import com.google.common.base.Defaults;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Type;
import java.util.Optional;

enum DefaultValueStubbingStrategy implements StubbingStrategy
{
    INSTANCE;


    @Override
    public boolean accepts(StubbingContext context, Type type) {
        return this.getDefaultValue(type).isPresent();
    }

    @Override
    public Object stub(StubbingContext context, Type type) {
        return this.getDefaultValue(type).orElseThrow(() -> new StubbingException(context.getSite(), type));
    }

    private Optional<?> getDefaultValue(Type type) {
        return Types.getRawType(type).flatMap(this::getDefaultValue);
    }

    private Optional<?> getDefaultValue(Class<?> clazz) {
        return Optional.ofNullable(Defaults.defaultValue((Class)Primitives.unwrap(clazz)));
    }
}

