/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.core.strategy;

import ch.leadrian.stubr.core.Matcher;
import ch.leadrian.stubr.core.StubbingContext;
import ch.leadrian.stubr.core.StubbingException;
import ch.leadrian.stubr.core.StubbingSite;
import ch.leadrian.stubr.core.StubbingStrategy;
import ch.leadrian.stubr.core.site.ConstructorParameterStubbingSite;
import ch.leadrian.stubr.core.site.StubbingSites;
import ch.leadrian.stubr.core.type.Types;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

final class ConstructorStubbingStrategy
implements StubbingStrategy {
    private final Matcher<? super Constructor<?>> constructorMatcher;
    private final Map<Class<?>, Constructor<?>> constructorsByClass = new ConcurrentHashMap();

    ConstructorStubbingStrategy(Matcher<? super Constructor<?>> constructorMatcher) {
        Objects.requireNonNull(constructorMatcher, "constructorMatcher");
        this.constructorMatcher = constructorMatcher;
    }

    @Override
    public boolean accepts(StubbingContext context, Type type) {
        return this.getConstructor(context, type).isPresent();
    }

    @Override
    public Object stub(StubbingContext context, Type type) {
        Constructor<?> constructor = this.getConstructor(context, type).orElseThrow(() -> new StubbingException("No matching constructor found", context.getSite(), type));
        Object[] parameterValues = this.stub(context, constructor);
        return this.invokeConstructor(constructor, parameterValues);
    }

    private Object invokeConstructor(Constructor<?> constructor, Object[] parameterValues) {
        constructor.setAccessible(true);
        try {
            return constructor.newInstance(parameterValues);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    private Object[] stub(StubbingContext context, Constructor<?> constructor) {
        return Arrays.stream(constructor.getParameters()).map(parameter -> this.stub(context, constructor, (Parameter)parameter)).toArray(Object[]::new);
    }

    private Object stub(StubbingContext context, Constructor<?> constructor, Parameter parameter) {
        ConstructorParameterStubbingSite site = StubbingSites.constructorParameter(context.getSite(), constructor, parameter);
        return context.getStubber().stub(parameter.getParameterizedType(), (StubbingSite)site);
    }

    private Optional<Constructor<?>> getConstructor(StubbingContext context, Type type) {
        return Types.getRawType(type).filter(this::isInstantiable).flatMap(rawType -> this.getConstructor(context, (Class<?>)rawType));
    }

    private boolean isInstantiable(Class<?> clazz) {
        return !Modifier.isAbstract(clazz.getModifiers()) && !clazz.isPrimitive() && !clazz.isEnum() && !clazz.isInterface();
    }

    private Optional<Constructor<?>> getConstructor(StubbingContext context, Class<?> type) {
        Constructor constructor = this.constructorsByClass.computeIfAbsent(type, clazz -> {
            List<Constructor<?>> constructors = this.getConstructors(context, (Class<?>)clazz);
            if (constructors.size() == 1) {
                return constructors.get(0);
            }
            return null;
        });
        return Optional.ofNullable(constructor);
    }

    private List<Constructor<?>> getConstructors(StubbingContext context, Class<?> type) {
        return Arrays.stream(type.getDeclaredConstructors()).filter(constructor -> !constructor.isSynthetic() && !Modifier.isPrivate(constructor.getModifiers())).filter(constructor -> this.constructorMatcher.matches(context, (Constructor<?>)constructor)).collect(Collectors.toList());
    }
}

