/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.core.strategy;

import ch.leadrian.stubr.core.StubbingContext;
import ch.leadrian.stubr.core.StubbingException;
import ch.leadrian.stubr.core.StubbingSite;
import ch.leadrian.stubr.core.site.ArrayStubbingSite;
import ch.leadrian.stubr.core.site.StubbingSites;
import ch.leadrian.stubr.core.strategy.SimpleStubbingStrategy;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.util.Objects;
import java.util.function.ToIntFunction;

final class ArrayStubbingStrategy
extends SimpleStubbingStrategy<Object> {
    private final ToIntFunction<? super StubbingContext> arraySize;

    ArrayStubbingStrategy(ToIntFunction<? super StubbingContext> arraySize) {
        Objects.requireNonNull(arraySize, "arraySize");
        this.arraySize = arraySize;
    }

    @Override
    protected boolean acceptsClass(StubbingContext context, Class<?> type) {
        return type.isArray();
    }

    @Override
    protected boolean acceptsParameterizedType(StubbingContext context, ParameterizedType type) {
        return false;
    }

    @Override
    protected Object stubClass(StubbingContext context, Class<?> type) {
        Class<?> componentType = type.getComponentType();
        Object array = Array.newInstance(componentType, this.arraySize.applyAsInt(context));
        ArrayStubbingSite site = StubbingSites.array(context.getSite(), componentType);
        int length = this.getArrayLength(array);
        for (int i = 0; i < length; ++i) {
            this.setArrayValue(array, i, context.getStubber().stub(componentType, (StubbingSite)site));
        }
        return array;
    }

    @Override
    protected Object stubParameterizedType(StubbingContext context, ParameterizedType type) {
        throw new StubbingException(context.getSite(), type);
    }

    private int getArrayLength(Object array) {
        if (array instanceof boolean[]) {
            return ((boolean[])array).length;
        }
        if (array instanceof byte[]) {
            return ((byte[])array).length;
        }
        if (array instanceof short[]) {
            return ((short[])array).length;
        }
        if (array instanceof char[]) {
            return ((char[])array).length;
        }
        if (array instanceof int[]) {
            return ((int[])array).length;
        }
        if (array instanceof long[]) {
            return ((long[])array).length;
        }
        if (array instanceof float[]) {
            return ((float[])array).length;
        }
        if (array instanceof double[]) {
            return ((double[])array).length;
        }
        if (array instanceof Object[]) {
            return ((Object[])array).length;
        }
        throw new StubbingException(String.format("Not an array: %s", array));
    }

    private void setArrayValue(Object array, int index, Object value) {
        if (array instanceof boolean[]) {
            ((boolean[])array)[index] = (Boolean)value;
        } else if (array instanceof byte[]) {
            ((byte[])array)[index] = (Byte)value;
        } else if (array instanceof short[]) {
            ((short[])array)[index] = (Short)value;
        } else if (array instanceof char[]) {
            ((char[])array)[index] = ((Character)value).charValue();
        } else if (array instanceof int[]) {
            ((int[])array)[index] = (Integer)value;
        } else if (array instanceof long[]) {
            ((long[])array)[index] = (Long)value;
        } else if (array instanceof float[]) {
            ((float[])array)[index] = ((Float)value).floatValue();
        } else if (array instanceof double[]) {
            ((double[])array)[index] = (Double)value;
        } else if (array instanceof Object[]) {
            ((Object[])array)[index] = value;
        } else {
            throw new StubbingException(String.format("Not an array: %s", array));
        }
    }
}

