/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.core.matcher;

import ch.leadrian.stubr.core.Matcher;
import ch.leadrian.stubr.core.StubbingContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Objects;

abstract class AnnotationMatcher<T extends AnnotatedElement>
implements Matcher<T> {
    static <T extends AnnotatedElement> AnnotationMatcher<T> by(String annotationName) {
        return new ByName(annotationName);
    }

    static <T extends AnnotatedElement> AnnotationMatcher<T> by(Class<? extends Annotation> annotationType) {
        return new ByType(annotationType);
    }

    static <T extends AnnotatedElement> AnnotationMatcher<T> by(Annotation annotation) {
        return new ByEquality(annotation);
    }

    private AnnotationMatcher() {
    }

    private static final class ByEquality<T extends AnnotatedElement>
    extends AnnotationMatcher<T> {
        private final Annotation annotation;

        ByEquality(Annotation annotation) {
            Objects.requireNonNull(annotation, "annotation");
            this.annotation = annotation;
        }

        @Override
        public boolean matches(StubbingContext context, T value) {
            Annotation annotationOnElement = value.getAnnotation(this.annotation.annotationType());
            return this.annotation.equals(annotationOnElement);
        }
    }

    private static final class ByType<T extends AnnotatedElement>
    extends AnnotationMatcher<T> {
        private final Class<? extends Annotation> annotationType;

        ByType(Class<? extends Annotation> annotationType) {
            Objects.requireNonNull(annotationType, "annotationType");
            this.annotationType = annotationType;
        }

        @Override
        public boolean matches(StubbingContext context, T value) {
            return value.isAnnotationPresent(this.annotationType);
        }
    }

    private static final class ByName<T extends AnnotatedElement>
    extends AnnotationMatcher<T> {
        private final String annotationName;

        ByName(String annotationName) {
            Objects.requireNonNull(annotationName, "annotationName");
            this.annotationName = annotationName;
        }

        @Override
        public boolean matches(StubbingContext context, T value) {
            return Arrays.stream(value.getAnnotations()).map(Annotation::annotationType).anyMatch(type -> this.annotationName.equals(type.getName()) || this.annotationName.equals(type.getSimpleName()));
        }
    }
}

