/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.core;

import ch.leadrian.stubr.core.StubbingSite;
import java.lang.reflect.Type;
import java.util.Optional;

public class StubbingException
extends IllegalStateException {
    static final long serialVersionUID = 4249103561555675566L;
    private final transient StubbingSite site;
    private final transient Type type;

    public StubbingException(String message, StubbingSite site, Type type) {
        super(String.format("Cannot stub %s at %s: %s", type, site, message));
        this.site = site;
        this.type = type;
    }

    public StubbingException(StubbingSite site, Type type) {
        super(String.format("Cannot stub %s at %s", type, site));
        this.site = site;
        this.type = type;
    }

    public StubbingException(String message) {
        super(message);
        this.site = null;
        this.type = null;
    }

    public Optional<StubbingSite> getSite() {
        return Optional.ofNullable(this.site);
    }

    public Optional<Type> getType() {
        return Optional.ofNullable(this.type);
    }
}

