/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.core;

import ch.leadrian.equalizer.Equalizer;
import ch.leadrian.equalizer.EqualsAndHashCode;
import com.google.common.base.MoreObjects;
import java.util.NoSuchElementException;
import java.util.function.Function;

public abstract class Result<T> {
    public static <T> Result<T> success(T value) {
        return new Success(value);
    }

    public static <T> Result<T> failure() {
        return Failure.INSTANCE;
    }

    private Result() {
    }

    public abstract T getValue();

    public final boolean isSuccess() {
        return !this.isFailure();
    }

    public abstract boolean isFailure();

    public abstract <U> Result<U> map(Function<T, U> var1);

    public abstract String toString();

    private static final class Failure<T>
    extends Result<T> {
        private static final Failure<Object> INSTANCE = new Failure();

        private Failure() {
        }

        @Override
        public T getValue() {
            throw new NoSuchElementException();
        }

        @Override
        public boolean isFailure() {
            return true;
        }

        @Override
        public <U> Result<U> map(Function<T, U> mappingFunction) {
            return Result.failure();
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private static final class Success<T>
    extends Result<T> {
        private static final EqualsAndHashCode<Success> EQUALS_AND_HASH_CODE = Equalizer.equalsAndHashCodeBuilder(Success.class).compareAndHash(Success::getValue).build();
        private final T value;

        private Success(T value) {
            this.value = value;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public boolean isFailure() {
            return false;
        }

        @Override
        public <U> Result<U> map(Function<T, U> mappingFunction) {
            return Result.success(mappingFunction.apply(this.value));
        }

        public boolean equals(Object obj) {
            return EQUALS_AND_HASH_CODE.equals((Object)this, obj);
        }

        public int hashCode() {
            return EQUALS_AND_HASH_CODE.hashCode((Object)this);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", this.value).toString();
        }
    }
}

