/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.core.type;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

public interface TypeVisitor<T> {
    public static <T> T accept(Type type, TypeVisitor<? extends T> visitor) {
        if (type instanceof Class) {
            return visitor.visit((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return visitor.visit((ParameterizedType)type);
        }
        if (type instanceof WildcardType) {
            return visitor.visit((WildcardType)type);
        }
        if (type instanceof TypeVariable) {
            return visitor.visit((TypeVariable)type);
        }
        if (type instanceof GenericArrayType) {
            return visitor.visit((GenericArrayType)type);
        }
        throw new UnsupportedOperationException(String.format("Unsupported type: %s", type));
    }

    public T visit(Class<?> var1);

    public T visit(ParameterizedType var1);

    public T visit(WildcardType var1);

    public T visit(TypeVariable<?> var1);

    public T visit(GenericArrayType var1);
}

