/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.core.type;

import ch.leadrian.equalizer.Equalizer;
import ch.leadrian.equalizer.EqualsAndHashCode;
import com.google.common.base.MoreObjects;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class TypeLiteral<T> {
    private static final EqualsAndHashCode<TypeLiteral> EQUALS_AND_HASH_CODE = Equalizer.equalsAndHashCodeBuilder(TypeLiteral.class).compareAndHash(TypeLiteral::getType).build();
    private final Type type;

    protected TypeLiteral() {
        Type superclass = this.getClass().getGenericSuperclass();
        if (!(superclass instanceof ParameterizedType)) {
            throw new IllegalStateException("Superclass must be parameterized");
        }
        Type[] typeArguments = ((ParameterizedType)superclass).getActualTypeArguments();
        if (typeArguments.length != 1) {
            throw new IllegalStateException("Expected exactly one type argument");
        }
        this.type = typeArguments[0];
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        return EQUALS_AND_HASH_CODE.equals((Object)this, obj);
    }

    public int hashCode() {
        return EQUALS_AND_HASH_CODE.hashCode((Object)this);
    }

    public String toString() {
        return MoreObjects.toStringHelper(TypeLiteral.class).add("type", (Object)this.type).toString();
    }
}

