/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.core.strategy;

import ch.leadrian.stubr.core.StubbingContext;
import ch.leadrian.stubr.core.strategy.SimpleStubbingStrategy;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntFunction;

final class SuppliedValueStubbingStrategy
extends SimpleStubbingStrategy<Object> {
    private final Type valueType;
    private final IntFunction<?> valueSupplier;
    private final AtomicInteger sequenceNumber = new AtomicInteger(0);

    SuppliedValueStubbingStrategy(Type valueType, IntFunction<?> valueSupplier) {
        Objects.requireNonNull(valueType, "valueType");
        Objects.requireNonNull(valueSupplier, "valueSupplier");
        this.valueType = valueType;
        this.valueSupplier = valueSupplier;
    }

    @Override
    protected boolean acceptsClass(StubbingContext context, Class<?> type) {
        return this.valueType == type;
    }

    @Override
    protected boolean acceptsParameterizedType(StubbingContext context, ParameterizedType type) {
        return this.valueType.equals(type);
    }

    @Override
    protected Object stubClass(StubbingContext context, Class<?> type) {
        return this.getNextValue();
    }

    @Override
    protected Object stubParameterizedType(StubbingContext context, ParameterizedType type) {
        return this.getNextValue();
    }

    private Object getNextValue() {
        return this.valueSupplier.apply(this.sequenceNumber.getAndIncrement());
    }
}

