/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.core.strategy;

import ch.leadrian.stubr.core.StubbingContext;
import ch.leadrian.stubr.core.StubbingException;
import ch.leadrian.stubr.core.StubbingSite;
import ch.leadrian.stubr.core.StubbingStrategy;
import ch.leadrian.stubr.core.site.StubbingSites;
import ch.leadrian.stubr.core.type.Types;
import com.google.common.base.StandardSystemProperty;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

enum ProxyStubbingStrategy implements StubbingStrategy
{
    CACHING(true),
    NON_CACHING(false);

    private final boolean cacheStubs;

    private ProxyStubbingStrategy(boolean cacheStubs) {
        this.cacheStubs = cacheStubs;
    }

    @Override
    public boolean accepts(StubbingContext context, Type type) {
        return Types.getRawType(type).filter(Class::isInterface).isPresent();
    }

    @Override
    public Object stub(StubbingContext context, Type type) {
        return Types.getRawType(type).map(clazz -> this.createProxy((Class<?>)clazz, this.getInvocationHandler(context))).orElseThrow(() -> new StubbingException(context.getSite(), type));
    }

    private InvocationHandler getInvocationHandler(StubbingContext context) {
        return this.cacheStubs ? new CachingInvocationHandler(context) : new SimpleInvocationHandler(context);
    }

    private Object createProxy(Class<?> clazz, InvocationHandler invocationHandler) {
        return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, invocationHandler);
    }

    private static enum Java9PlusDefaultMethodInvocationHandler implements InvocationHandler
    {
        INSTANCE;


        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return MethodHandles.lookup().findSpecial(method.getDeclaringClass(), method.getName(), MethodType.methodType(method.getReturnType(), new Class[0]), method.getDeclaringClass()).bindTo(proxy).invokeWithArguments(args);
        }
    }

    private static enum Java8DefaultMethodInvocationHandler implements InvocationHandler
    {
        INSTANCE;


        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Class<?> declaringClass = method.getDeclaringClass();
            Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
            constructor.setAccessible(true);
            MethodHandles.Lookup lookup = (MethodHandles.Lookup)constructor.newInstance(declaringClass, 15);
            return lookup.unreflectSpecial(method, declaringClass).bindTo(proxy).invokeWithArguments(args);
        }
    }

    private static final class CachingInvocationHandler
    extends StubbingInvocationHandler {
        private final Map<Method, Object> stubbedValues = new ConcurrentHashMap<Method, Object>();

        CachingInvocationHandler(StubbingContext context) {
            super(context);
        }

        @Override
        protected Object getReturnValue(Method method) {
            return this.stubbedValues.computeIfAbsent(method, this::stub);
        }
    }

    private static final class SimpleInvocationHandler
    extends StubbingInvocationHandler {
        SimpleInvocationHandler(StubbingContext context) {
            super(context);
        }

        @Override
        protected Object getReturnValue(Method method) {
            return this.stub(method);
        }
    }

    private static abstract class StubbingInvocationHandler
    implements InvocationHandler {
        private static final InvocationHandler DEFAULT_METHOD_INVOCATION_HANDLER;
        private final StubbingContext context;

        StubbingInvocationHandler(StubbingContext context) {
            this.context = context;
        }

        @Override
        public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.isDefault()) {
                return DEFAULT_METHOD_INVOCATION_HANDLER.invoke(proxy, method, args);
            }
            return this.getReturnValue(method);
        }

        protected final Object stub(Method method) {
            Type returnType = method.getGenericReturnType();
            if (returnType == Void.TYPE || returnType == Void.class) {
                return null;
            }
            return this.context.getStubber().stub(returnType, (StubbingSite)StubbingSites.methodReturnValue(this.context.getSite(), method));
        }

        protected abstract Object getReturnValue(Method var1);

        static {
            float version = Float.parseFloat(System.getProperty(StandardSystemProperty.JAVA_CLASS_VERSION.key()));
            boolean isJava8 = version <= 52.0f;
            DEFAULT_METHOD_INVOCATION_HANDLER = isJava8 ? Java8DefaultMethodInvocationHandler.INSTANCE : Java9PlusDefaultMethodInvocationHandler.INSTANCE;
        }
    }
}

