/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.core.strategy;

import ch.leadrian.stubr.core.StubbingContext;
import ch.leadrian.stubr.core.strategy.SimpleStubbingStrategy;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;

final class ImplementationStubbingStrategy
extends SimpleStubbingStrategy<Object> {
    private final Type targetType;
    private final Type implementationType;

    ImplementationStubbingStrategy(Type targetType, Type implementationType) {
        Objects.requireNonNull(targetType, "targetType");
        Objects.requireNonNull(implementationType, "implementationType");
        this.targetType = targetType;
        this.implementationType = implementationType;
    }

    @Override
    protected boolean acceptsClass(StubbingContext context, Class<?> type) {
        return this.targetType == type;
    }

    @Override
    protected boolean acceptsParameterizedType(StubbingContext context, ParameterizedType type) {
        return this.targetType.equals(type);
    }

    @Override
    protected Object stubClass(StubbingContext context, Class<?> type) {
        return this.stub(context);
    }

    @Override
    protected Object stubParameterizedType(StubbingContext context, ParameterizedType type) {
        return this.stub(context);
    }

    private Object stub(StubbingContext context) {
        return context.getStubber().stub(this.implementationType, context.getSite());
    }
}

