/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.core.strategy;

import ch.leadrian.stubr.core.StubbingContext;
import ch.leadrian.stubr.core.strategy.SimpleStubbingStrategy;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;

final class ConstantValueStubbingStrategy
extends SimpleStubbingStrategy<Object> {
    private final Type valueType;
    private final Object value;

    ConstantValueStubbingStrategy(Type valueClass, Object value) {
        Objects.requireNonNull(valueClass, "valueType");
        Objects.requireNonNull(value, "value");
        this.valueType = valueClass;
        this.value = value;
    }

    @Override
    protected boolean acceptsClass(StubbingContext context, Class<?> type) {
        return this.valueType == type;
    }

    @Override
    protected boolean acceptsParameterizedType(StubbingContext context, ParameterizedType type) {
        return this.valueType.equals(type);
    }

    @Override
    protected Object stubClass(StubbingContext context, Class<?> type) {
        return this.value;
    }

    @Override
    protected Object stubParameterizedType(StubbingContext context, ParameterizedType type) {
        return this.value;
    }
}

