/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.stubr.core;

import ch.leadrian.stubr.core.CompositeStubber;
import ch.leadrian.stubr.core.Result;
import ch.leadrian.stubr.core.StubberBuilder;
import ch.leadrian.stubr.core.StubberImpl;
import ch.leadrian.stubr.core.StubbingContext;
import ch.leadrian.stubr.core.StubbingException;
import ch.leadrian.stubr.core.StubbingSite;
import ch.leadrian.stubr.core.site.StubbingSites;
import ch.leadrian.stubr.core.type.TypeLiteral;
import ch.leadrian.stubr.core.type.Types;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;

public abstract class Stubber {
    public static StubberBuilder builder() {
        return new StubberImpl.Builder();
    }

    public static Stubber compose(List<? extends Stubber> stubbers) {
        return new CompositeStubber(stubbers);
    }

    public static Stubber compose(Stubber ... stubbers) {
        return Stubber.compose(Arrays.asList(stubbers));
    }

    protected abstract Result<?> tryToStub(Type var1, StubbingContext var2);

    public final Result<?> tryToStub(Type type, StubbingSite site) {
        StubbingContext context = new StubbingContext(this, site);
        return this.tryToStub(type, context);
    }

    public final Object stub(Type type, StubbingSite site) {
        Result<?> result = this.tryToStub(type, site);
        if (result.isFailure()) {
            throw new StubbingException(String.format("Failed to stub instance of %s", type));
        }
        return result.getValue();
    }

    public final <T> Result<T> tryToStub(Class<T> type, StubbingSite site) {
        return this.tryToStub((Type)type, site).map(value -> Primitives.wrap((Class)type).cast(value));
    }

    public final <T> Result<T> tryToStub(Class<T> type) {
        return this.tryToStub(type, (StubbingSite)StubbingSites.unknown());
    }

    public final <T> T stub(Class<T> type, StubbingSite site) {
        return Primitives.wrap(type).cast(this.stub((Type)type, site));
    }

    public final <T> T stub(Class<T> type) {
        return this.stub(type, (StubbingSite)StubbingSites.unknown());
    }

    public final <T> Result<T> tryToStub(TypeLiteral<T> typeLiteral, StubbingSite site) {
        Class<T> rawType = this.getWrappedRawType(typeLiteral);
        return this.tryToStub(typeLiteral.getType(), site).map(rawType::cast);
    }

    public final <T> Result<T> tryToStub(TypeLiteral<T> typeLiteral) {
        return this.tryToStub(typeLiteral, (StubbingSite)StubbingSites.unknown());
    }

    public final <T> T stub(TypeLiteral<T> typeLiteral, StubbingSite site) {
        Class<T> rawType = this.getWrappedRawType(typeLiteral);
        return rawType.cast(this.stub(typeLiteral.getType(), site));
    }

    public final <T> T stub(TypeLiteral<T> typeLiteral) {
        return this.stub(typeLiteral, (StubbingSite)StubbingSites.unknown());
    }

    private <T> Class<T> getWrappedRawType(TypeLiteral<T> typeLiteral) {
        Type type = typeLiteral.getType();
        return Types.getRawType(type).map(Primitives::wrap).orElseThrow(() -> new IllegalArgumentException(String.format("Cannot get raw type of %s", type)));
    }
}

