/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.samp.kamp.gradle.plugin.pluginwrappergenerator.codegenerator;

import ch.leadrian.samp.kamp.cidl.model.Function;
import ch.leadrian.samp.kamp.cidl.model.Parameter;
import ch.leadrian.samp.kamp.gradle.plugin.pluginwrappergenerator.PluginWrapperGeneratorExtension;
import ch.leadrian.samp.kamp.gradle.plugin.pluginwrappergenerator.codegenerator.CodeGenerator;
import ch.leadrian.samp.kamp.gradle.plugin.pluginwrappergenerator.codegenerator.TypeMappingsKt;
import ch.leadrian.samp.kamp.gradle.plugin.pluginwrappergenerator.util.FunctionsKt;
import ch.leadrian.samp.kamp.gradle.plugin.pluginwrappergenerator.util.ParametersKt;
import ch.leadrian.samp.kamp.gradle.plugin.pluginwrappergenerator.util.TypeSpecsKt;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeSpec;
import java.io.Writer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0004H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0017H\u0002J\f\u0010\u0018\u001a\u00020\u0019*\u00020\u0019H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u000bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lch/leadrian/samp/kamp/gradle/plugin/pluginwrappergenerator/codegenerator/CallbacksInterfaceGenerator;", "Lch/leadrian/samp/kamp/gradle/plugin/pluginwrappergenerator/codegenerator/CodeGenerator;", "callbacks", "", "Lch/leadrian/samp/kamp/cidl/model/Function;", "extension", "Lch/leadrian/samp/kamp/gradle/plugin/pluginwrappergenerator/PluginWrapperGeneratorExtension;", "outputDirectory", "Ljava/nio/file/Path;", "(Ljava/util/List;Lch/leadrian/samp/kamp/gradle/plugin/pluginwrappergenerator/PluginWrapperGeneratorExtension;Ljava/nio/file/Path;)V", "callbacksInterfaceClassName", "", "fileName", "getFileName", "()Ljava/lang/String;", "buildCallbackFunction", "Lcom/squareup/kotlinpoet/FunSpec;", "function", "generate", "", "writer", "Ljava/io/Writer;", "addCallbackFunctions", "Lcom/squareup/kotlinpoet/TypeSpec$Builder;", "addCallbacksInterfaceClass", "Lcom/squareup/kotlinpoet/FileSpec$Builder;", "kamp-plugin-wrapper-generator"})
public final class CallbacksInterfaceGenerator
extends CodeGenerator {
    private final String callbacksInterfaceClassName;
    @NotNull
    private final String fileName;
    private final List<Function> callbacks;
    private final PluginWrapperGeneratorExtension extension;

    @Override
    @NotNull
    protected String getFileName() {
        return this.fileName;
    }

    @Override
    protected void generate(@NotNull Writer writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        this.addCallbacksInterfaceClass(FileSpec.Companion.builder(this.extension.getPackageName(), this.callbacksInterfaceClassName)).build().writeTo((Appendable)writer);
    }

    private final FileSpec.Builder addCallbacksInterfaceClass(@NotNull FileSpec.Builder $receiver) {
        TypeSpec callsbacksInterfaceTypeSpec = this.addCallbackFunctions(TypeSpecsKt.addGeneratedAnnotation(TypeSpec.Companion.interfaceBuilder(this.callbacksInterfaceClassName), Reflection.getOrCreateKotlinClass(CallbacksInterfaceGenerator.class))).build();
        return $receiver.addType(callsbacksInterfaceTypeSpec);
    }

    private final TypeSpec.Builder addCallbackFunctions(@NotNull TypeSpec.Builder $receiver) {
        Iterable $receiver$iv = this.callbacks;
        for (Object element$iv : $receiver$iv) {
            Function it = (Function)element$iv;
            $receiver.addFunction(this.buildCallbackFunction(it));
        }
        return $receiver;
    }

    /*
     * WARNING - void declaration
     */
    private final FunSpec buildCallbackFunction(Function function) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)function.getParameters();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Parameter parameter = (Parameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            ParameterSpec parameterSpec = ParameterSpec.Companion.builder(it.getName(), ParametersKt.getKotlinType((Parameter)it), new KModifier[0]).build();
            collection.add(parameterSpec);
        }
        List parameterSpecs = (List)destination$iv$iv;
        return FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Companion.builder(FunctionsKt.transformName(function, this.extension.getCallbacksCaseFormat(), this.extension.getPrefixesToRemove$kamp_plugin_wrapper_generator())).addModifiers(new KModifier[]{KModifier.ABSTRACT}), (TypeName)((TypeName)TypeMappingsKt.getKotlinType(function.getType())), null, (int)2, null).addParameters((Iterable)parameterSpecs).build();
    }

    public CallbacksInterfaceGenerator(@NotNull List<Function> callbacks2, @NotNull PluginWrapperGeneratorExtension extension2, @NotNull Path outputDirectory) {
        Intrinsics.checkParameterIsNotNull(callbacks2, (String)"callbacks");
        Intrinsics.checkParameterIsNotNull((Object)extension2, (String)"extension");
        Intrinsics.checkParameterIsNotNull((Object)outputDirectory, (String)"outputDirectory");
        super(outputDirectory);
        this.callbacks = callbacks2;
        this.extension = extension2;
        this.callbacksInterfaceClassName = this.extension.getPluginName() + "Callbacks";
        this.fileName = this.callbacksInterfaceClassName + ".kt";
    }
}

