/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.samp.kamp.gradle.plugin.pluginwrappergenerator.codegenerator;

import ch.leadrian.samp.kamp.cidl.model.Function;
import ch.leadrian.samp.kamp.cidl.model.Parameter;
import ch.leadrian.samp.kamp.gradle.plugin.pluginwrappergenerator.PluginWrapperGeneratorExtension;
import ch.leadrian.samp.kamp.gradle.plugin.pluginwrappergenerator.codegenerator.CallbackManagerGenerator;
import ch.leadrian.samp.kamp.gradle.plugin.pluginwrappergenerator.codegenerator.CodeGenerator;
import ch.leadrian.samp.kamp.gradle.plugin.pluginwrappergenerator.util.FunctionsKt;
import ch.leadrian.samp.kamp.gradle.plugin.pluginwrappergenerator.util.ParametersKt;
import ch.leadrian.samp.kamp.gradle.plugin.pluginwrappergenerator.util.TypeSpecsKt;
import com.google.common.base.CaseFormat;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeSpec;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0014\u0010\u001c\u001a\u00020\u0019*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\u0014\u0010\u001f\u001a\u00020\u0019*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\f\u0010 \u001a\u00020!*\u00020!H\u0002J\f\u0010\"\u001a\u00020#*\u00020#H\u0002J\f\u0010$\u001a\u00020#*\u00020#H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0011X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006%"}, d2={"Lch/leadrian/samp/kamp/gradle/plugin/pluginwrappergenerator/codegenerator/CallbackManagerGenerator;", "Lch/leadrian/samp/kamp/gradle/plugin/pluginwrappergenerator/codegenerator/CodeGenerator;", "callbacks", "", "Lch/leadrian/samp/kamp/cidl/model/Function;", "extension", "Lch/leadrian/samp/kamp/gradle/plugin/pluginwrappergenerator/PluginWrapperGeneratorExtension;", "outputDirectory", "Ljava/nio/file/Path;", "(Ljava/util/List;Lch/leadrian/samp/kamp/gradle/plugin/pluginwrappergenerator/PluginWrapperGeneratorExtension;Ljava/nio/file/Path;)V", "amxCallbackFactoryClass", "Lcom/squareup/kotlinpoet/ClassName;", "amxCallbackFactoryParameterSpec", "Lcom/squareup/kotlinpoet/ParameterSpec;", "amxCallbackFactoryPropertySpec", "Lcom/squareup/kotlinpoet/PropertySpec;", "callbackManagerClassName", "", "callbacksInterfaceClass", "callbacksInterfaceParameterSpec", "callbacksInterfacePropertySpec", "fileName", "getFileName", "()Ljava/lang/String;", "generate", "", "writer", "Ljava/io/Writer;", "addCallbackCreation", "Lcom/squareup/kotlinpoet/FunSpec$Builder;", "callback", "addCallbackInvocationStatement", "addCallbackManagerClass", "Lcom/squareup/kotlinpoet/FileSpec$Builder;", "addConstructor", "Lcom/squareup/kotlinpoet/TypeSpec$Builder;", "addInitializeFunction", "kamp-plugin-wrapper-generator"})
public final class CallbackManagerGenerator
extends CodeGenerator {
    private final String callbackManagerClassName;
    private final ClassName callbacksInterfaceClass;
    private final ClassName amxCallbackFactoryClass;
    private final ParameterSpec amxCallbackFactoryParameterSpec;
    private final PropertySpec amxCallbackFactoryPropertySpec;
    private final ParameterSpec callbacksInterfaceParameterSpec;
    private final PropertySpec callbacksInterfacePropertySpec;
    @NotNull
    private final String fileName;
    private final List<Function> callbacks;
    private final PluginWrapperGeneratorExtension extension;

    @Override
    @NotNull
    protected String getFileName() {
        return this.fileName;
    }

    @Override
    protected void generate(@NotNull Writer writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        this.addCallbackManagerClass(FileSpec.Companion.builder(this.extension.getPackageName(), this.callbackManagerClassName)).build().writeTo((Appendable)writer);
    }

    private final FileSpec.Builder addCallbackManagerClass(@NotNull FileSpec.Builder $receiver) {
        TypeSpec callsbacksInterfaceTypeSpec = this.addInitializeFunction(this.addConstructor(TypeSpecsKt.addGeneratedAnnotation(TypeSpec.Companion.classBuilder(this.callbackManagerClassName), Reflection.getOrCreateKotlinClass(CallbackManagerGenerator.class)))).addModifiers(new KModifier[]{KModifier.INTERNAL}).addAnnotation(Reflection.getOrCreateKotlinClass(Singleton.class)).build();
        return $receiver.addType(callsbacksInterfaceTypeSpec);
    }

    private final TypeSpec.Builder addConstructor(@NotNull TypeSpec.Builder $receiver) {
        FunSpec constructorSpec = FunSpec.Companion.constructorBuilder().addAnnotation(Reflection.getOrCreateKotlinClass(Inject.class)).addParameter(this.amxCallbackFactoryParameterSpec).addParameter(this.callbacksInterfaceParameterSpec).build();
        $receiver.primaryConstructor(constructorSpec);
        $receiver.addProperty(this.amxCallbackFactoryPropertySpec);
        $receiver.addProperty(this.callbacksInterfacePropertySpec);
        return $receiver;
    }

    private final TypeSpec.Builder addInitializeFunction(@NotNull TypeSpec.Builder $receiver) {
        FunSpec.Builder initializeSpec = FunSpec.Companion.builder("initialize").addAnnotation(Reflection.getOrCreateKotlinClass(PostConstruct.class));
        Iterable $receiver$iv = this.callbacks;
        for (Object element$iv : $receiver$iv) {
            Function callback = (Function)element$iv;
            this.addCallbackCreation(initializeSpec, callback);
        }
        return $receiver.addFunction(initializeSpec.build());
    }

    private final void addCallbackCreation(@NotNull FunSpec.Builder $receiver, Function callback) {
        String string;
        Collection collection = callback.getParameters();
        if (!collection.isEmpty()) {
            String parameterization2 = CollectionsKt.joinToString$default((Iterable)callback.getParameters(), (CharSequence)", ", null, null, (int)0, null, (Function1)addCallbackCreation.format.parameterization.1.INSTANCE, (int)30, null);
            string = "%N.create" + callback.getParameters().size() + '<' + parameterization2 + ">(%S)";
        } else {
            string = "%N.create0(%S)";
        }
        String format2 = string;
        List args = CollectionsKt.mutableListOf((Object[])new Object[]{this.amxCallbackFactoryPropertySpec});
        Iterable $receiver$iv = callback.getParameters();
        for (Object element$iv : $receiver$iv) {
            Parameter it = (Parameter)element$iv;
            args.add(ParametersKt.getKotlinType(it));
        }
        args.add(callback.getName());
        $receiver$iv = args;
        String string2 = format2;
        FunSpec.Builder builder = $receiver;
        Iterable iterable = $receiver$iv;
        if (iterable == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Iterable thisCollection$iv = iterable;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        if (objectArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray2 = objectArray;
        builder.beginControlFlow(string2, Arrays.copyOf(objectArray2, objectArray2.length));
        this.addCallbackInvocationStatement($receiver, callback);
        $receiver.endControlFlow();
    }

    private final void addCallbackInvocationStatement(@NotNull FunSpec.Builder $receiver, Function callback) {
        String statement;
        String lambdaParameters2 = CollectionsKt.joinToString$default((Iterable)callback.getParameters(), (CharSequence)", ", null, null, (int)0, null, (Function1)addCallbackInvocationStatement.lambdaParameters.1.INSTANCE, (int)30, null);
        String callbackName = FunctionsKt.transformName(callback, this.extension.getCallbacksCaseFormat(), this.extension.getPrefixesToRemove$kamp_plugin_wrapper_generator());
        Collection collection = callback.getParameters();
        String string = statement = !collection.isEmpty() ? lambdaParameters2 + " -> %N." + callbackName + '(' + lambdaParameters2 + ')' : "%N." + callbackName + "()";
        if (Intrinsics.areEqual((Object)callback.getType(), (Object)"bool")) {
            statement = statement + ".let { result -> if (result) 1 else 0 }";
        } else if (Intrinsics.areEqual((Object)callback.getType(), (Object)"void")) {
            statement = statement + "; 0";
        } else if (Intrinsics.areEqual((Object)callback.getType(), (Object)"int") ^ true) {
            throw (Throwable)new IllegalArgumentException("Unsupported callback return type: " + callback.getType());
        }
        $receiver.addStatement(statement, new Object[]{this.callbacksInterfacePropertySpec});
    }

    public CallbackManagerGenerator(@NotNull List<Function> callbacks2, @NotNull PluginWrapperGeneratorExtension extension2, @NotNull Path outputDirectory) {
        Intrinsics.checkParameterIsNotNull(callbacks2, (String)"callbacks");
        Intrinsics.checkParameterIsNotNull((Object)extension2, (String)"extension");
        Intrinsics.checkParameterIsNotNull((Object)outputDirectory, (String)"outputDirectory");
        super(outputDirectory);
        this.callbacks = callbacks2;
        this.extension = extension2;
        this.callbackManagerClassName = this.extension.getPluginName() + "CallbackManager";
        this.callbacksInterfaceClass = new ClassName(this.extension.getPackageName(), this.extension.getPluginName() + "Callbacks", new String[0]);
        this.amxCallbackFactoryClass = new ClassName("ch.leadrian.samp.kamp.core.api.amx", "AmxCallbackFactory", new String[0]);
        this.amxCallbackFactoryParameterSpec = ParameterSpec.Companion.builder("amxCallbackFactory", (TypeName)this.amxCallbackFactoryClass, new KModifier[0]).build();
        this.amxCallbackFactoryPropertySpec = PropertySpec.Companion.builder(this.amxCallbackFactoryParameterSpec.getName(), this.amxCallbackFactoryParameterSpec.getType(), new KModifier[0]).addModifiers(new KModifier[]{KModifier.PRIVATE}).initializer("%N", new Object[]{this.amxCallbackFactoryParameterSpec}).build();
        String string = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, this.callbacksInterfaceClass.getSimpleName());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UPPER_CAMEL.to(LOWER_CAM\u2026nterfaceClass.simpleName)");
        this.callbacksInterfaceParameterSpec = ParameterSpec.Companion.builder(string, (TypeName)this.callbacksInterfaceClass, new KModifier[0]).build();
        this.callbacksInterfacePropertySpec = PropertySpec.Companion.builder(this.callbacksInterfaceParameterSpec.getName(), this.callbacksInterfaceParameterSpec.getType(), new KModifier[0]).addModifiers(new KModifier[]{KModifier.PRIVATE}).initializer("%N", new Object[]{this.callbacksInterfaceParameterSpec}).build();
        this.fileName = this.callbackManagerClassName + ".kt";
    }
}

