/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.samp.kamp.annotationprocessor.codegen;

import ch.leadrian.samp.kamp.annotationprocessor.CallbackAnnotationProcessorException;
import ch.leadrian.samp.kamp.annotationprocessor.codegen.CodeGenerationKt;
import ch.leadrian.samp.kamp.annotationprocessor.codegen.TypeMirrorsKt;
import ch.leadrian.samp.kamp.annotationprocessor.model.CallbackListenerDefinition;
import ch.leadrian.samp.kamp.annotations.InlineCallback;
import ch.leadrian.samp.kamp.annotations.Receiver;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.LambdaTypeName;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeNames;
import com.squareup.kotlinpoet.TypeSpec;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bJ \u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J*\u0010\u001e\u001a\u00020\u001f*\u00020\u001f2\u0006\u0010\t\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\u0006\u0010 \u001a\u00020\u0004H\u0002J\u0014\u0010!\u001a\u00020\"*\u00020\"2\u0006\u0010\r\u001a\u00020\u000eH\u0002J*\u0010#\u001a\u00020\"*\u00020\"2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013H\u0002J\u001c\u0010$\u001a\u00020%*\u00020%2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010&\u001a\u00020%*\u00020%2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0014\u0010'\u001a\u00020\"*\u00020\"2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010(\u001a\u00020\u001f*\u00020\u001f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006)"}, d2={"Lch/leadrian/samp/kamp/annotationprocessor/codegen/CallbackReceiverGenerator;", "", "()V", "isReceiver", "", "Ljavax/lang/model/element/VariableElement;", "(Ljavax/lang/model/element/VariableElement;)Z", "buildActionParameterSpec", "Lcom/squareup/kotlinpoet/ParameterSpec;", "actionReceiver", "actionParameterTypes", "", "Lcom/squareup/kotlinpoet/TypeName;", "listenerDefinition", "Lch/leadrian/samp/kamp/annotationprocessor/model/CallbackListenerDefinition;", "(Ljavax/lang/model/element/VariableElement;[Lcom/squareup/kotlinpoet/TypeName;Lch/leadrian/samp/kamp/annotationprocessor/model/CallbackListenerDefinition;)Lcom/squareup/kotlinpoet/ParameterSpec;", "buildAnonymousListenerTypeSpec", "Lcom/squareup/kotlinpoet/TypeSpec;", "actionParameters", "", "buildFileSpec", "Lcom/squareup/kotlinpoet/FileSpec;", "className", "Lcom/squareup/kotlinpoet/ClassName;", "generate", "", "outputDirectory", "Ljava/nio/file/Path;", "writeFile", "fileSpec", "addActionInvocation", "Lcom/squareup/kotlinpoet/FunSpec$Builder;", "hasReturnValue", "addAddListenerFunction", "Lcom/squareup/kotlinpoet/TypeSpec$Builder;", "addAnonymousListenerCallbackFunction", "addCallbackReceiverClass", "Lcom/squareup/kotlinpoet/FileSpec$Builder;", "addInlineCallbackFunction", "addRemoveListenerFunction", "kotlinizeParameterTypes", "kamp-annotation-processor"})
public final class CallbackReceiverGenerator {
    public final void generate(@NotNull CallbackListenerDefinition listenerDefinition, @NotNull Path outputDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)listenerDefinition, (String)"listenerDefinition");
        Intrinsics.checkParameterIsNotNull((Object)outputDirectory, (String)"outputDirectory");
        ClassName className = new ClassName(listenerDefinition.getApiPackageName(), StringsKt.removeSuffix((String)listenerDefinition.getType().getSimpleName(), (CharSequence)"Listener") + "Receiver", new String[0]);
        FileSpec fileSpec = this.buildFileSpec(className, listenerDefinition);
        this.writeFile(outputDirectory, className, fileSpec);
    }

    private final FileSpec buildFileSpec(ClassName className, CallbackListenerDefinition listenerDefinition) {
        return this.addInlineCallbackFunction(this.addCallbackReceiverClass(FileSpec.Companion.builder(className.getPackageName(), className.getSimpleName()), className, listenerDefinition), listenerDefinition, className).build();
    }

    private final FileSpec.Builder addCallbackReceiverClass(@NotNull FileSpec.Builder $receiver, ClassName className, CallbackListenerDefinition listenerDefinition) {
        TypeSpec typeSpec = this.addRemoveListenerFunction(this.addAddListenerFunction(CodeGenerationKt.addGeneratedAnnotation(TypeSpec.Companion.interfaceBuilder(className), Reflection.getOrCreateKotlinClass(this.getClass())), listenerDefinition), listenerDefinition).build();
        return $receiver.addType(typeSpec);
    }

    private final TypeSpec.Builder addAddListenerFunction(@NotNull TypeSpec.Builder $receiver, CallbackListenerDefinition listenerDefinition) {
        return $receiver.addFunction(FunSpec.Companion.builder("add" + listenerDefinition.getType().getSimpleName()).addModifiers(new KModifier[]{KModifier.ABSTRACT}).addParameter(ParameterSpec.Companion.builder("listener", (TypeName)listenerDefinition.getType(), new KModifier[0]).build()).build());
    }

    private final TypeSpec.Builder addRemoveListenerFunction(@NotNull TypeSpec.Builder $receiver, CallbackListenerDefinition listenerDefinition) {
        return $receiver.addFunction(FunSpec.Companion.builder("remove" + listenerDefinition.getType().getSimpleName()).addModifiers(new KModifier[]{KModifier.ABSTRACT}).addParameter(ParameterSpec.Companion.builder("listener", (TypeName)listenerDefinition.getType(), new KModifier[0]).build()).build());
    }

    /*
     * WARNING - void declaration
     */
    private final FileSpec.Builder addInlineCallbackFunction(@NotNull FileSpec.Builder $receiver, CallbackListenerDefinition listenerDefinition, ClassName className) {
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Object v2;
        Object element$iv2;
        block5: {
            List<? extends VariableElement> list = listenerDefinition.getMethod().getParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"listenerDefinition.method.parameters");
            Iterable $receiver$iv = list;
            for (Object element$iv2 : $receiver$iv) {
                VariableElement it;
                VariableElement variableElement = it = (VariableElement)element$iv2;
                Intrinsics.checkExpressionValueIsNotNull((Object)variableElement, (String)"it");
                if (!this.isReceiver(variableElement)) continue;
                v2 = element$iv2;
                break block5;
            }
            v2 = null;
        }
        VariableElement variableElement = v2;
        if (variableElement == null) {
            throw (Throwable)new CallbackAnnotationProcessorException("Could not find " + Receiver.class + " annotation on " + listenerDefinition.getType());
        }
        VariableElement actionReceiver = variableElement;
        List<? extends VariableElement> list = listenerDefinition.getMethod().getParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"listenerDefinition.method.parameters");
        Iterable $receiver$iv = list;
        element$iv2 = $receiver$iv;
        Iterable destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            VariableElement it;
            VariableElement variableElement2 = it = (VariableElement)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)variableElement2, (String)"it");
            if (!(!this.isReceiver(variableElement2))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List actionParameters = (List)destination$iv$iv;
        Iterable $receiver$iv2 = actionParameters;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            VariableElement $i$a$1$filter = (VariableElement)item$iv$iv;
            Collection collection = destination$iv$iv2;
            void v6 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"it");
            TypeName typeName = TypeMirrorsKt.getKotlinTypeName((VariableElement)v6);
            collection.add(typeName);
        }
        $receiver$iv2 = (List)destination$iv$iv2;
        Iterable thisCollection$iv = $receiver$iv2;
        TypeName[] typeNameArray = thisCollection$iv.toArray(new TypeName[0]);
        if (typeNameArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        TypeName[] actionParameterTypes = typeNameArray;
        ParameterSpec parameterSpec = this.buildActionParameterSpec(actionReceiver, actionParameterTypes, listenerDefinition);
        TypeSpec listenerTypeSpec = this.buildAnonymousListenerTypeSpec(listenerDefinition, actionReceiver, actionParameters);
        String functionName = listenerDefinition.getMethod().getAnnotation(InlineCallback.class).name();
        FunSpec funSpec = FunSpec.Builder.returns$default((FunSpec.Builder)FunSpec.Builder.receiver$default((FunSpec.Builder)CodeGenerationKt.addGeneratedAnnotation(FunSpec.Companion.builder(functionName), Reflection.getOrCreateKotlinClass(this.getClass())).addModifiers(new KModifier[]{KModifier.INLINE}), (TypeName)((TypeName)className), null, (int)2, null).addParameter(parameterSpec), (TypeName)((TypeName)listenerDefinition.getType()), null, (int)2, null).addStatement("val listener = %L", new Object[]{listenerTypeSpec}).addStatement("add" + listenerDefinition.getType().getSimpleName() + "(listener)", new Object[0]).addStatement("return listener", new Object[0]).build();
        return $receiver.addFunction(funSpec);
    }

    private final ParameterSpec buildActionParameterSpec(VariableElement actionReceiver, TypeName[] actionParameterTypes, CallbackListenerDefinition listenerDefinition) {
        TypeMirror typeMirror = actionReceiver.asType();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror, (String)"actionReceiver.asType()");
        TypeName typeName = TypeMirrorsKt.toKotlinTypeName(typeMirror);
        TypeMirror typeMirror2 = listenerDefinition.getMethod().getReturnType();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeMirror2, (String)"listenerDefinition.method.returnType");
        TypeName[] typeNameArray = Arrays.copyOf(actionParameterTypes, actionParameterTypes.length);
        TypeName typeName2 = TypeNames.get((TypeMirror)typeMirror2);
        return ParameterSpec.Companion.builder("action", (TypeName)LambdaTypeName.Companion.get(typeName, typeNameArray, typeName2), new KModifier[0]).addModifiers(new KModifier[]{KModifier.CROSSINLINE}).build();
    }

    private final TypeSpec buildAnonymousListenerTypeSpec(CallbackListenerDefinition listenerDefinition, VariableElement actionReceiver, List<? extends VariableElement> actionParameters) {
        return this.addAnonymousListenerCallbackFunction(TypeSpec.Builder.addSuperinterface$default((TypeSpec.Builder)CodeGenerationKt.addGeneratedAnnotation(TypeSpec.Companion.anonymousClassBuilder(), Reflection.getOrCreateKotlinClass(this.getClass())), (TypeName)((TypeName)listenerDefinition.getType()), null, (int)2, null), listenerDefinition, actionReceiver, actionParameters).build();
    }

    private final TypeSpec.Builder addAnonymousListenerCallbackFunction(@NotNull TypeSpec.Builder $receiver, CallbackListenerDefinition listenerDefinition, VariableElement actionReceiver, List<? extends VariableElement> actionParameters) {
        boolean hasReturnValue = listenerDefinition.getIgnoredReturnValueType() != null;
        FunSpec funSpec = this.addActionInvocation(this.kotlinizeParameterTypes(FunSpec.Companion.overriding(listenerDefinition.getMethod()), listenerDefinition), actionReceiver, actionParameters, hasReturnValue).build();
        return $receiver.addFunction(funSpec);
    }

    /*
     * WARNING - void declaration
     */
    private final FunSpec.Builder addActionInvocation(@NotNull FunSpec.Builder $receiver, VariableElement actionReceiver, List<? extends VariableElement> actionParameters, boolean hasReturnValue) {
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable;
        List $receiver2 = iterable = CollectionsKt.toMutableList((Collection)actionParameters);
        $receiver2.add(0, actionReceiver);
        iterable = iterable;
        $receiver2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            VariableElement variableElement = (VariableElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            String string = it.getSimpleName().toString();
            collection.add(string);
        }
        List invocationParameters = (List)destination$iv$iv;
        String actionInvocation = "action.invoke(" + CollectionsKt.joinToString$default((Iterable)invocationParameters, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + ')';
        return hasReturnValue ? $receiver.addStatement("return " + actionInvocation, new Object[0]) : $receiver.addStatement(actionInvocation, new Object[0]);
    }

    private final FunSpec.Builder kotlinizeParameterTypes(@NotNull FunSpec.Builder $receiver, CallbackListenerDefinition listenerDefinition) {
        Iterable $receiver$iv = (Iterable)RangesKt.until((int)0, (int)$receiver.getParameters().size());
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            VariableElement variableElement = listenerDefinition.getMethod().getParameters().get(i);
            Intrinsics.checkExpressionValueIsNotNull((Object)variableElement, (String)"listenerDefinition.method.parameters[i]");
            TypeName kotlinType = TypeMirrorsKt.getKotlinTypeName(variableElement);
            $receiver.getParameters().set(i, ParameterSpec.toBuilder$default((ParameterSpec)((ParameterSpec)$receiver.getParameters().get(i)), null, (TypeName)kotlinType, (int)1, null).build());
        }
        return $receiver;
    }

    private final boolean isReceiver(@NotNull VariableElement $receiver) {
        return $receiver.getAnnotation(Receiver.class) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void writeFile(Path outputDirectory, ClassName className, FileSpec fileSpec) {
        Iterable $receiver$iv = StringsKt.split$default((CharSequence)className.getPackageName(), (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null);
        Path accumulator$iv = outputDirectory;
        for (Object element$iv : $receiver$iv) {
            void p2;
            String string = (String)element$iv;
            Path p1 = accumulator$iv;
            accumulator$iv = p1.resolve((String)p2);
        }
        Path packageDirectory = accumulator$iv;
        Files.createDirectories(packageDirectory, new FileAttribute[0]);
        Path outputFile = packageDirectory.resolve(className.getSimpleName() + ".kt");
        Closeable closeable = Files.newBufferedWriter(outputFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        Object object = null;
        try {
            BufferedWriter it;
            BufferedWriter bufferedWriter = it = (BufferedWriter)closeable;
            Intrinsics.checkExpressionValueIsNotNull((Object)bufferedWriter, (String)"it");
            fileSpec.writeTo((Appendable)bufferedWriter);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }
}

