/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.samp.kamp.annotationprocessor.codegen;

import ch.leadrian.samp.kamp.annotationprocessor.codegen.CallbackHandlerGenerator;
import ch.leadrian.samp.kamp.annotationprocessor.codegen.CodeGenerationKt;
import ch.leadrian.samp.kamp.annotationprocessor.codegen.TypeMirrorsKt;
import ch.leadrian.samp.kamp.annotationprocessor.model.CallbackListenerDefinition;
import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.ParameterSpec;
import com.squareup.kotlinpoet.ParameterizedTypeName;
import com.squareup.kotlinpoet.TypeName;
import com.squareup.kotlinpoet.TypeSpec;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.lang.model.element.Name;
import javax.lang.model.element.VariableElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fJ \u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u0011\u001a\u00020\u0012*\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u0013\u001a\u00020\n*\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010\u0018\u001a\u00020\n*\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0014\u0010\u0019\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u001a"}, d2={"Lch/leadrian/samp/kamp/annotationprocessor/codegen/CallbackHandlerGenerator;", "", "()V", "buildFileSpec", "Lcom/squareup/kotlinpoet/FileSpec;", "className", "Lcom/squareup/kotlinpoet/ClassName;", "listenerDefinition", "Lch/leadrian/samp/kamp/annotationprocessor/model/CallbackListenerDefinition;", "generate", "", "outputDirectory", "Ljava/nio/file/Path;", "writeFile", "fileSpec", "addCallbackFunction", "Lcom/squareup/kotlinpoet/TypeSpec$Builder;", "addCallbackHandlerClass", "Lcom/squareup/kotlinpoet/FileSpec$Builder;", "addCancellableCallbackFunction", "ignoredReturnValueType", "Lcom/squareup/kotlinpoet/TypeName;", "addListenerFunctionCall", "Lcom/squareup/kotlinpoet/FunSpec$Builder;", "addUnitCallbackFunction", "kotlinizeParameterTypes", "kamp-annotation-processor"})
public final class CallbackHandlerGenerator {
    public final void generate(@NotNull CallbackListenerDefinition listenerDefinition, @NotNull Path outputDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)listenerDefinition, (String)"listenerDefinition");
        Intrinsics.checkParameterIsNotNull((Object)outputDirectory, (String)"outputDirectory");
        ClassName className = new ClassName(listenerDefinition.getRuntimePackageName(), StringsKt.removeSuffix((String)listenerDefinition.getType().getSimpleName(), (CharSequence)"Listener") + "Handler", new String[0]);
        FileSpec fileSpec = this.buildFileSpec(className, listenerDefinition);
        this.writeFile(outputDirectory, className, fileSpec);
    }

    private final FileSpec buildFileSpec(ClassName className, CallbackListenerDefinition listenerDefinition) {
        return this.addCallbackHandlerClass(FileSpec.Companion.builder(listenerDefinition.getRuntimePackageName(), className.getSimpleName()), className, listenerDefinition).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void writeFile(Path outputDirectory, ClassName className, FileSpec fileSpec) {
        Iterable $receiver$iv = StringsKt.split$default((CharSequence)className.getPackageName(), (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null);
        Path accumulator$iv = outputDirectory;
        for (Object element$iv : $receiver$iv) {
            void p2;
            String string = (String)element$iv;
            Path p1 = accumulator$iv;
            accumulator$iv = p1.resolve((String)p2);
        }
        Path packageDirectory = accumulator$iv;
        Files.createDirectories(packageDirectory, new FileAttribute[0]);
        Path outputFile = packageDirectory.resolve(className.getSimpleName() + ".kt");
        Closeable closeable = Files.newBufferedWriter(outputFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        Object object = null;
        try {
            BufferedWriter it;
            BufferedWriter bufferedWriter = it = (BufferedWriter)closeable;
            Intrinsics.checkExpressionValueIsNotNull((Object)bufferedWriter, (String)"it");
            fileSpec.writeTo((Appendable)bufferedWriter);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
    }

    private final FileSpec.Builder addCallbackHandlerClass(@NotNull FileSpec.Builder $receiver, ClassName className, CallbackListenerDefinition listenerDefinition) {
        TypeSpec typeSpec = this.addCallbackFunction(TypeSpec.Builder.addSuperinterface$default((TypeSpec.Builder)CodeGenerationKt.addGeneratedAnnotation(TypeSpec.Companion.classBuilder(className).addModifiers(new KModifier[]{KModifier.INTERNAL}), Reflection.getOrCreateKotlinClass(this.getClass())).addAnnotation(Reflection.getOrCreateKotlinClass(Singleton.class)).primaryConstructor(FunSpec.Companion.constructorBuilder().addAnnotation(Reflection.getOrCreateKotlinClass(Inject.class)).build()).superclass((TypeName)ParameterizedTypeName.Companion.get(new ClassName("ch.leadrian.samp.kamp.core.api.callback", "CallbackListenerRegistry", new String[0]), new TypeName[]{(TypeName)listenerDefinition.getType()})).addSuperclassConstructorParameter("%T::class", new Object[]{listenerDefinition.getType()}), (TypeName)((TypeName)listenerDefinition.getType()), null, (int)2, null), listenerDefinition).build();
        return $receiver.addType(typeSpec);
    }

    private final TypeSpec.Builder addCallbackFunction(@NotNull TypeSpec.Builder $receiver, CallbackListenerDefinition listenerDefinition) {
        TypeName ignoredReturnValueType = listenerDefinition.getIgnoredReturnValueType();
        if (ignoredReturnValueType != null) {
            this.addCancellableCallbackFunction($receiver, listenerDefinition, ignoredReturnValueType);
        } else {
            this.addUnitCallbackFunction($receiver, listenerDefinition);
        }
        return $receiver;
    }

    private final void addCancellableCallbackFunction(@NotNull TypeSpec.Builder $receiver, CallbackListenerDefinition listenerDefinition, TypeName ignoredReturnValueType) {
        FunSpec funSpec = this.addListenerFunctionCall(this.kotlinizeParameterTypes(FunSpec.Companion.overriding(listenerDefinition.getMethod()), listenerDefinition).beginControlFlow("return listeners.map", new Object[0]), listenerDefinition).endControlFlow().beginControlFlow(".firstOrNull", new Object[0]).addStatement("it != %T", new Object[]{ignoredReturnValueType}).endControlFlow().addStatement("?: %T", new Object[]{ignoredReturnValueType}).build();
        $receiver.addFunction(funSpec);
    }

    private final void addUnitCallbackFunction(@NotNull TypeSpec.Builder $receiver, CallbackListenerDefinition listenerDefinition) {
        FunSpec funSpec = this.addListenerFunctionCall(this.kotlinizeParameterTypes(FunSpec.Companion.overriding(listenerDefinition.getMethod()), listenerDefinition).beginControlFlow("listeners.forEach", new Object[0]), listenerDefinition).endControlFlow().build();
        $receiver.addFunction(funSpec);
    }

    private final FunSpec.Builder addListenerFunctionCall(@NotNull FunSpec.Builder $receiver, CallbackListenerDefinition listenerDefinition) {
        String string = "it.%N(" + CollectionsKt.joinToString$default((Iterable)$receiver.getParameters(), (CharSequence)", ", null, null, (int)0, null, (Function1)addListenerFunctionCall.1.INSTANCE, (int)30, null) + ')';
        Object[] objectArray = new Object[1];
        Name name = listenerDefinition.getMethod().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"listenerDefinition.method.simpleName");
        objectArray[0] = name;
        return $receiver.addStatement(string, objectArray);
    }

    private final FunSpec.Builder kotlinizeParameterTypes(@NotNull FunSpec.Builder $receiver, CallbackListenerDefinition listenerDefinition) {
        Iterable $receiver$iv = (Iterable)RangesKt.until((int)0, (int)$receiver.getParameters().size());
        Iterator iterator = $receiver$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)iterator).nextInt();
            VariableElement variableElement = listenerDefinition.getMethod().getParameters().get(i);
            Intrinsics.checkExpressionValueIsNotNull((Object)variableElement, (String)"listenerDefinition.method.parameters[i]");
            TypeName kotlinType = TypeMirrorsKt.getKotlinTypeName(variableElement);
            $receiver.getParameters().set(i, ParameterSpec.toBuilder$default((ParameterSpec)((ParameterSpec)$receiver.getParameters().get(i)), null, (TypeName)kotlinType, (int)1, null).build());
        }
        return $receiver;
    }
}

