/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.equalizer;

import ch.leadrian.equalizer.BooleanHashStep;
import ch.leadrian.equalizer.ByteHashStep;
import ch.leadrian.equalizer.CharHashStep;
import ch.leadrian.equalizer.DeepHashStep;
import ch.leadrian.equalizer.DelegatingHashStep;
import ch.leadrian.equalizer.DoubleHashStep;
import ch.leadrian.equalizer.FloatHashStep;
import ch.leadrian.equalizer.HashCode;
import ch.leadrian.equalizer.HashCodeBuilder;
import ch.leadrian.equalizer.HashStep;
import ch.leadrian.equalizer.IdentityHashStep;
import ch.leadrian.equalizer.IntHashStep;
import ch.leadrian.equalizer.LongHashStep;
import ch.leadrian.equalizer.ShallowHashStep;
import ch.leadrian.equalizer.ShortHashStep;
import ch.leadrian.equalizer.util.function.ToByteFunction;
import ch.leadrian.equalizer.util.function.ToCharFunction;
import ch.leadrian.equalizer.util.function.ToFloatFunction;
import ch.leadrian.equalizer.util.function.ToShortFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

final class HashCodeImpl<T>
implements HashCode<T> {
    private final List<HashStep<T>> hashSteps;

    private HashCodeImpl(List<? extends HashStep<T>> hashSteps) {
        this.hashSteps = new ArrayList<HashStep<T>>(hashSteps);
    }

    @Override
    public int hashCode(T object) {
        if (object == null) {
            return 0;
        }
        if (this.hashSteps.isEmpty()) {
            return System.identityHashCode(object);
        }
        int result = 1;
        for (int i = 0; i < this.hashSteps.size(); ++i) {
            result = 31 * result + this.hashSteps.get(i).hash(object);
        }
        return result;
    }

    static final class Builder<T>
    implements HashCodeBuilder<T> {
        private final List<HashStep<T>> hashSteps = new ArrayList<HashStep<T>>();

        Builder() {
        }

        @Override
        public HashCodeBuilder<T> withSuper(HashCode<? super T> superHashCode) {
            Objects.requireNonNull(superHashCode, "superHashCode must not be null");
            return this.addHashStep(new DelegatingHashStep<Object>(superHashCode::hashCode));
        }

        @Override
        public HashCodeBuilder<T> hash(Function<? super T, ?> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must not be null");
            return this.addHashStep(new ShallowHashStep<T>(valueExtractor));
        }

        @Override
        public HashCodeBuilder<T> hashPrimitive(ToByteFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must not be null");
            return this.addHashStep(new ByteHashStep<T>(valueExtractor));
        }

        @Override
        public HashCodeBuilder<T> hashPrimitive(ToShortFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must not be null");
            return this.addHashStep(new ShortHashStep<T>(valueExtractor));
        }

        @Override
        public HashCodeBuilder<T> hashPrimitive(ToCharFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must not be null");
            return this.addHashStep(new CharHashStep<T>(valueExtractor));
        }

        @Override
        public HashCodeBuilder<T> hashPrimitive(ToIntFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must not be null");
            return this.addHashStep(new IntHashStep<T>(valueExtractor));
        }

        @Override
        public HashCodeBuilder<T> hashPrimitive(ToLongFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must not be null");
            return this.addHashStep(new LongHashStep<T>(valueExtractor));
        }

        @Override
        public HashCodeBuilder<T> hashPrimitive(ToFloatFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must not be null");
            return this.addHashStep(new FloatHashStep<T>(valueExtractor));
        }

        @Override
        public HashCodeBuilder<T> hashPrimitive(ToDoubleFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must not be null");
            return this.addHashStep(new DoubleHashStep<T>(valueExtractor));
        }

        @Override
        public HashCodeBuilder<T> hashPrimitive(Predicate<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must not be null");
            return this.addHashStep(new BooleanHashStep<T>(valueExtractor));
        }

        @Override
        public HashCodeBuilder<T> hashDeep(Function<? super T, ?> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must not be null");
            return this.addHashStep(new DeepHashStep<T>(valueExtractor));
        }

        @Override
        public HashCodeBuilder<T> hashIdentity(Function<? super T, ?> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must not be null");
            return this.addHashStep(new IdentityHashStep<T>(valueExtractor));
        }

        private HashCodeBuilder<T> addHashStep(HashStep<T> step) {
            this.hashSteps.add(step);
            return this;
        }

        @Override
        public HashCode<T> build() {
            return new HashCodeImpl(this.hashSteps);
        }

        @Override
        public boolean isEmpty() {
            return this.hashSteps.isEmpty();
        }
    }
}

