/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.equalizer;

import ch.leadrian.equalizer.ComparisonStep;
import ch.leadrian.equalizer.util.function.ToFloatFunction;

final class FloatComparisonStep<T>
implements ComparisonStep<T> {
    private final ToFloatFunction<? super T> valueExtractor;

    FloatComparisonStep(ToFloatFunction<? super T> valueExtractor) {
        this.valueExtractor = valueExtractor;
    }

    @Override
    public boolean isEqual(T object1, T object2) {
        float value1 = this.valueExtractor.applyAsFloat(object1);
        float value2 = this.valueExtractor.applyAsFloat(object2);
        return Float.floatToIntBits(value1) == Float.floatToIntBits(value2);
    }
}

