/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.equalizer;

import ch.leadrian.equalizer.BooleanComparisonStep;
import ch.leadrian.equalizer.ByteComparisonStep;
import ch.leadrian.equalizer.CharComparisonStep;
import ch.leadrian.equalizer.ClassMatcher;
import ch.leadrian.equalizer.ClassMatchers;
import ch.leadrian.equalizer.ComparisonStep;
import ch.leadrian.equalizer.DeepComparisonStep;
import ch.leadrian.equalizer.DelegatingComparisonStep;
import ch.leadrian.equalizer.DoubleComparisonStep;
import ch.leadrian.equalizer.Equals;
import ch.leadrian.equalizer.EqualsBuilder;
import ch.leadrian.equalizer.FloatComparisonStep;
import ch.leadrian.equalizer.IdentityComparisonStep;
import ch.leadrian.equalizer.IntComparisonStep;
import ch.leadrian.equalizer.LongComparisonStep;
import ch.leadrian.equalizer.ShallowComparisonStep;
import ch.leadrian.equalizer.ShortComparisonStep;
import ch.leadrian.equalizer.util.function.ToByteFunction;
import ch.leadrian.equalizer.util.function.ToCharFunction;
import ch.leadrian.equalizer.util.function.ToFloatFunction;
import ch.leadrian.equalizer.util.function.ToShortFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

final class EqualsImpl<T>
implements Equals<T> {
    private final Class<T> targetClass;
    private final List<ComparisonStep<T>> comparisonSteps;
    private final ClassMatcher<T> classMatcher;

    private EqualsImpl(Class<T> targetClass, List<? extends ComparisonStep<T>> comparisonSteps, ClassMatcher<T> classMatcher) {
        this.targetClass = targetClass;
        this.comparisonSteps = new ArrayList<ComparisonStep<T>>(comparisonSteps);
        this.classMatcher = classMatcher;
    }

    @Override
    public boolean equals(T object, Object otherObject) {
        if (object == otherObject) {
            return true;
        }
        if (object == null || otherObject == null) {
            return false;
        }
        if (!this.classMatcher.classesMatch(object, otherObject)) {
            return false;
        }
        return this.isEqual(object, this.targetClass.cast(otherObject));
    }

    private boolean isEqual(T object, T otherObject) {
        if (this.comparisonSteps.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.comparisonSteps.size(); ++i) {
            if (this.comparisonSteps.get(i).isEqual(object, otherObject)) continue;
            return false;
        }
        return true;
    }

    static final class Builder<T>
    implements EqualsBuilder<T> {
        private final Class<T> targetClass;
        private final List<ComparisonStep<T>> comparisonSteps = new ArrayList<ComparisonStep<T>>();
        private ClassMatcher<T> classMatcher;

        Builder(Class<T> targetClass) {
            Objects.requireNonNull(targetClass, "targetClass must not be null");
            this.targetClass = targetClass;
            this.classMatcher = ClassMatchers.instanceOf(targetClass);
        }

        @Override
        public EqualsBuilder<T> withSuper(Equals<? super T> superEquals) {
            Objects.requireNonNull(superEquals, "superEquals must not be null");
            return this.equalIf(superEquals::equals);
        }

        @Override
        public EqualsBuilder<T> classMatcher(ClassMatcher<T> classMatcher) {
            Objects.requireNonNull(classMatcher, "classMatcher must not be null");
            this.classMatcher = classMatcher;
            return this;
        }

        @Override
        public EqualsBuilder<T> compare(Function<? super T, ?> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must not be null");
            return this.addComparisonStep(new ShallowComparisonStep<T>(valueExtractor));
        }

        @Override
        public EqualsBuilder<T> comparePrimitive(ToByteFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must not be null");
            return this.addComparisonStep(new ByteComparisonStep<T>(valueExtractor));
        }

        @Override
        public EqualsBuilder<T> comparePrimitive(ToShortFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must not be null");
            return this.addComparisonStep(new ShortComparisonStep<T>(valueExtractor));
        }

        @Override
        public EqualsBuilder<T> comparePrimitive(ToCharFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must not be null");
            return this.addComparisonStep(new CharComparisonStep<T>(valueExtractor));
        }

        @Override
        public EqualsBuilder<T> comparePrimitive(ToIntFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must not be null");
            return this.addComparisonStep(new IntComparisonStep<T>(valueExtractor));
        }

        @Override
        public EqualsBuilder<T> comparePrimitive(ToLongFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must not be null");
            return this.addComparisonStep(new LongComparisonStep<T>(valueExtractor));
        }

        @Override
        public EqualsBuilder<T> comparePrimitive(ToFloatFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must not be null");
            return this.addComparisonStep(new FloatComparisonStep<T>(valueExtractor));
        }

        @Override
        public EqualsBuilder<T> comparePrimitive(ToDoubleFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must not be null");
            return this.addComparisonStep(new DoubleComparisonStep<T>(valueExtractor));
        }

        @Override
        public EqualsBuilder<T> comparePrimitive(Predicate<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must not be null");
            return this.addComparisonStep(new BooleanComparisonStep<T>(valueExtractor));
        }

        @Override
        public EqualsBuilder<T> compareDeep(Function<? super T, ?> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must not be null");
            return this.addComparisonStep(new DeepComparisonStep<T>(valueExtractor));
        }

        @Override
        public EqualsBuilder<T> compareIdentity(Function<? super T, ?> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must not be null");
            return this.addComparisonStep(new IdentityComparisonStep<T>(valueExtractor));
        }

        @Override
        public EqualsBuilder<T> equalIf(BiPredicate<? super T, ? super T> condition) {
            Objects.requireNonNull(condition, "condition must not be null");
            return this.addComparisonStep(new DelegatingComparisonStep<T>(condition));
        }

        private EqualsBuilder<T> addComparisonStep(ComparisonStep<T> step) {
            this.comparisonSteps.add(step);
            return this;
        }

        @Override
        public Equals<T> build() {
            return new EqualsImpl(this.targetClass, this.comparisonSteps, this.classMatcher);
        }

        @Override
        public boolean isEmpty() {
            return this.comparisonSteps.isEmpty();
        }
    }
}

