/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.equalizer;

import ch.leadrian.equalizer.ClassMatcher;
import ch.leadrian.equalizer.Equalizer;
import ch.leadrian.equalizer.Equals;
import ch.leadrian.equalizer.EqualsAndHashCode;
import ch.leadrian.equalizer.EqualsAndHashCodeBuilder;
import ch.leadrian.equalizer.EqualsBuilder;
import ch.leadrian.equalizer.HashCode;
import ch.leadrian.equalizer.HashCodeBuilder;
import ch.leadrian.equalizer.util.function.ToByteFunction;
import ch.leadrian.equalizer.util.function.ToCharFunction;
import ch.leadrian.equalizer.util.function.ToFloatFunction;
import ch.leadrian.equalizer.util.function.ToShortFunction;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

final class EqualsAndHashCodeImpl<T>
implements EqualsAndHashCode<T> {
    private final Equals<T> equals;
    private final HashCode<T> hashCode;

    private EqualsAndHashCodeImpl(Equals<T> equals, HashCode<T> hashCode) {
        this.equals = equals;
        this.hashCode = hashCode;
    }

    @Override
    public boolean equals(T object, Object otherObject) {
        return this.equals.equals(object, otherObject);
    }

    @Override
    public int hashCode(T object) {
        return this.hashCode.hashCode(object);
    }

    static final class Builder<T>
    implements EqualsAndHashCodeBuilder<T> {
        private final EqualsBuilder<T> equalsBuilder;
        private final HashCodeBuilder<T> hashCodeBuilder;

        Builder(Class<T> targetClass) {
            Objects.requireNonNull(targetClass, "targetClass must not be null");
            this.equalsBuilder = Equalizer.equalsBuilder(targetClass);
            this.hashCodeBuilder = Equalizer.hashCodeBuilder();
        }

        @Override
        public EqualsAndHashCodeBuilder<T> withSuper(EqualsAndHashCode<? super T> superEqualsAndHashCode) {
            Objects.requireNonNull(superEqualsAndHashCode, "superEqualsAndHashCode must be null");
            this.equalsBuilder.withSuper(superEqualsAndHashCode);
            this.hashCodeBuilder.withSuper(superEqualsAndHashCode);
            return this;
        }

        @Override
        public EqualsAndHashCodeBuilder<T> classMatcher(ClassMatcher<T> classMatcher) {
            this.equalsBuilder.classMatcher(classMatcher);
            return this;
        }

        @Override
        public EqualsAndHashCodeBuilder<T> compare(Function<? super T, ?> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must be null");
            this.equalsBuilder.compare(valueExtractor);
            return this;
        }

        @Override
        public EqualsAndHashCodeBuilder<T> comparePrimitive(ToByteFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must be null");
            this.equalsBuilder.comparePrimitive(valueExtractor);
            return this;
        }

        @Override
        public EqualsAndHashCodeBuilder<T> comparePrimitive(ToShortFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must be null");
            this.equalsBuilder.comparePrimitive(valueExtractor);
            return this;
        }

        @Override
        public EqualsAndHashCodeBuilder<T> comparePrimitive(ToCharFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must be null");
            this.equalsBuilder.comparePrimitive(valueExtractor);
            return this;
        }

        @Override
        public EqualsAndHashCodeBuilder<T> comparePrimitive(ToIntFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must be null");
            this.equalsBuilder.comparePrimitive(valueExtractor);
            return this;
        }

        @Override
        public EqualsAndHashCodeBuilder<T> comparePrimitive(ToLongFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must be null");
            this.equalsBuilder.comparePrimitive(valueExtractor);
            return this;
        }

        @Override
        public EqualsAndHashCodeBuilder<T> comparePrimitive(ToFloatFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must be null");
            this.equalsBuilder.comparePrimitive(valueExtractor);
            return this;
        }

        @Override
        public EqualsAndHashCodeBuilder<T> comparePrimitive(ToDoubleFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must be null");
            this.equalsBuilder.comparePrimitive(valueExtractor);
            return this;
        }

        @Override
        public EqualsAndHashCodeBuilder<T> comparePrimitive(Predicate<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must be null");
            this.equalsBuilder.comparePrimitive(valueExtractor);
            return this;
        }

        @Override
        public EqualsAndHashCodeBuilder<T> compareDeep(Function<? super T, ?> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must be null");
            this.equalsBuilder.compareDeep(valueExtractor);
            return this;
        }

        @Override
        public EqualsAndHashCodeBuilder<T> compareIdentity(Function<? super T, ?> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must be null");
            this.equalsBuilder.compareIdentity(valueExtractor);
            return this;
        }

        @Override
        public EqualsAndHashCodeBuilder<T> compareAndHash(Function<? super T, ?> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must be null");
            this.equalsBuilder.compare(valueExtractor);
            this.hashCodeBuilder.hash(valueExtractor);
            return this;
        }

        @Override
        public EqualsAndHashCodeBuilder<T> compareAndHashPrimitive(ToByteFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must be null");
            this.equalsBuilder.comparePrimitive(valueExtractor);
            this.hashCodeBuilder.hashPrimitive(valueExtractor);
            return this;
        }

        @Override
        public EqualsAndHashCodeBuilder<T> compareAndHashPrimitive(ToShortFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must be null");
            this.equalsBuilder.comparePrimitive(valueExtractor);
            this.hashCodeBuilder.hashPrimitive(valueExtractor);
            return this;
        }

        @Override
        public EqualsAndHashCodeBuilder<T> compareAndHashPrimitive(ToCharFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must be null");
            this.equalsBuilder.comparePrimitive(valueExtractor);
            this.hashCodeBuilder.hashPrimitive(valueExtractor);
            return this;
        }

        @Override
        public EqualsAndHashCodeBuilder<T> compareAndHashPrimitive(ToIntFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must be null");
            this.equalsBuilder.comparePrimitive(valueExtractor);
            this.hashCodeBuilder.hashPrimitive(valueExtractor);
            return this;
        }

        @Override
        public EqualsAndHashCodeBuilder<T> compareAndHashPrimitive(ToLongFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must be null");
            this.equalsBuilder.comparePrimitive(valueExtractor);
            this.hashCodeBuilder.hashPrimitive(valueExtractor);
            return this;
        }

        @Override
        public EqualsAndHashCodeBuilder<T> compareAndHashPrimitive(ToFloatFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must be null");
            this.equalsBuilder.comparePrimitive(valueExtractor);
            this.hashCodeBuilder.hashPrimitive(valueExtractor);
            return this;
        }

        @Override
        public EqualsAndHashCodeBuilder<T> compareAndHashPrimitive(ToDoubleFunction<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must be null");
            this.equalsBuilder.comparePrimitive(valueExtractor);
            this.hashCodeBuilder.hashPrimitive(valueExtractor);
            return this;
        }

        @Override
        public EqualsAndHashCodeBuilder<T> compareAndHashPrimitive(Predicate<? super T> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must be null");
            this.equalsBuilder.comparePrimitive(valueExtractor);
            this.hashCodeBuilder.hashPrimitive(valueExtractor);
            return this;
        }

        @Override
        public EqualsAndHashCodeBuilder<T> compareAndHashDeep(Function<? super T, ?> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must be null");
            this.equalsBuilder.compareDeep(valueExtractor);
            this.hashCodeBuilder.hashDeep(valueExtractor);
            return this;
        }

        @Override
        public EqualsAndHashCodeBuilder<T> compareAndHashIdentity(Function<? super T, ?> valueExtractor) {
            Objects.requireNonNull(valueExtractor, "valueExtractor must be null");
            this.equalsBuilder.compareIdentity(valueExtractor);
            this.hashCodeBuilder.hashIdentity(valueExtractor);
            return this;
        }

        @Override
        public EqualsAndHashCodeBuilder<T> equalIf(BiPredicate<? super T, ? super T> condition) {
            Objects.requireNonNull(condition, "condition must be null");
            this.equalsBuilder.equalIf(condition);
            return this;
        }

        @Override
        public EqualsAndHashCode<T> build() {
            this.validate();
            return new EqualsAndHashCodeImpl(this.equalsBuilder.build(), this.hashCodeBuilder.build());
        }

        private void validate() {
            if (!this.equalsBuilder.isEmpty() && this.hashCodeBuilder.isEmpty()) {
                throw new IllegalStateException("If at least one comparison step has configured, then at least one hash step must be configured as well");
            }
        }

        @Override
        public boolean isEmpty() {
            return this.equalsBuilder.isEmpty() && this.hashCodeBuilder.isEmpty();
        }
    }
}

