/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.equalizer;

import ch.leadrian.equalizer.ComparisonStep;
import java.util.function.ToDoubleFunction;

final class DoubleComparisonStep<T>
implements ComparisonStep<T> {
    private final ToDoubleFunction<? super T> valueExtractor;

    DoubleComparisonStep(ToDoubleFunction<? super T> valueExtractor) {
        this.valueExtractor = valueExtractor;
    }

    @Override
    public boolean isEqual(T object1, T object2) {
        double value1 = this.valueExtractor.applyAsDouble(object1);
        double value2 = this.valueExtractor.applyAsDouble(object2);
        return Double.doubleToLongBits(value1) == Double.doubleToLongBits(value2);
    }
}

