/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.equalizer;

import ch.leadrian.equalizer.ValueExtractingHashStep;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;

final class DeepHashStep<T>
extends ValueExtractingHashStep<T> {
    DeepHashStep(Function<? super T, ?> valueExtractor) {
        super(valueExtractor);
    }

    @Override
    int hashValue(Object value) {
        if (value instanceof Object[]) {
            return Arrays.deepHashCode((Object[])value);
        }
        if (value instanceof byte[]) {
            return Arrays.hashCode((byte[])value);
        }
        if (value instanceof short[]) {
            return Arrays.hashCode((short[])value);
        }
        if (value instanceof int[]) {
            return Arrays.hashCode((int[])value);
        }
        if (value instanceof long[]) {
            return Arrays.hashCode((long[])value);
        }
        if (value instanceof char[]) {
            return Arrays.hashCode((char[])value);
        }
        if (value instanceof float[]) {
            return Arrays.hashCode((float[])value);
        }
        if (value instanceof double[]) {
            return Arrays.hashCode((double[])value);
        }
        if (value instanceof boolean[]) {
            return Arrays.hashCode((boolean[])value);
        }
        return Objects.hashCode(value);
    }
}

