/*
 * Decompiled with CFR 0.152.
 */
package ch.leadrian.equalizer;

import ch.leadrian.equalizer.ClassMatcher;
import java.util.Objects;

public final class ClassMatchers {
    private ClassMatchers() {
    }

    public static <T> ClassMatcher<T> instanceOf(Class<T> targetClass) {
        return new InstanceOf<T>(targetClass);
    }

    public static <T> ClassMatcher<T> exactClass(Class<T> targetClass) {
        return new ExactClass<T>(targetClass);
    }

    public static <T> ClassMatcher<T> sameClass() {
        return SameClass.INSTANCE;
    }

    private static class SameClass
    implements ClassMatcher<Object> {
        static final SameClass INSTANCE = new SameClass();

        private SameClass() {
        }

        @Override
        public boolean classesMatch(Object object, Object otherObject) {
            return object.getClass() == otherObject.getClass();
        }
    }

    private static class ExactClass<T>
    implements ClassMatcher<T> {
        private final Class<T> targetClass;

        ExactClass(Class<T> targetClass) {
            Objects.requireNonNull(targetClass, "targetClass must not be null");
            this.targetClass = targetClass;
        }

        @Override
        public boolean classesMatch(T object, Object otherObject) {
            return object.getClass() == this.targetClass && otherObject.getClass() == this.targetClass;
        }
    }

    private static class InstanceOf<T>
    implements ClassMatcher<T> {
        private final Class<T> targetClass;

        InstanceOf(Class<T> targetClass) {
            Objects.requireNonNull(targetClass, "targetClass must not be null");
            this.targetClass = targetClass;
        }

        @Override
        public boolean classesMatch(T object, Object otherObject) {
            return this.targetClass.isInstance(otherObject);
        }
    }
}

