/*
 * Copyright (C) 2019 Adrian-Philipp Leuenberger
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Garbage-free, fluent builders for easily writing correct {@link java.lang.Object#equals(java.lang.Object)} and
 * {@link java.lang.Object#hashCode()} implementations while honouring the contracts between both methods.
 *
 * @see ch.leadrian.equalizer.Equalizer
 * @see ch.leadrian.equalizer.Equals
 * @see ch.leadrian.equalizer.HashCode
 * @see ch.leadrian.equalizer.EqualsAndHashCode
 * @see ch.leadrian.equalizer.EqualsBuilder
 * @see ch.leadrian.equalizer.HashCodeBuilder
 * @see ch.leadrian.equalizer.EqualsAndHashCodeBuilder
 * @see java.lang.Object#hashCode()
 * @see java.lang.Object#equals(java.lang.Object)
 */
package ch.leadrian.equalizer;