/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.file.format;

import ch.kk7.confij.source.file.format.ConfijSourceFormat;
import ch.kk7.confij.source.file.format.FormatParsingException;
import ch.kk7.confij.tree.ConfijNode;
import ch.kk7.confij.tree.NodeDefinition;
import java.net.URI;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import lombok.NonNull;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class YamlFormat
implements ConfijSourceFormat {
    private final Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());

    public void override(ConfijNode simpleConfig, String content) {
        Iterable yamlIterable;
        try {
            yamlIterable = this.yaml.loadAll(content);
        }
        catch (Exception e) {
            throw FormatParsingException.invalidFormat((String)"YAML", (String)"content cannot be parsed:\n{}", (Object[])new Object[]{content, e});
        }
        yamlIterable.forEach(root -> {
            Object simpleRoot = this.simplify(root);
            ConfijNode newConfig = ConfijNode.newRootFor((NodeDefinition)simpleConfig.getConfig()).initializeFromMap(simpleRoot);
            simpleConfig.overrideWith(newConfig);
        });
    }

    private Object simplify(Object yaml) {
        if (yaml == null) {
            return null;
        }
        if (yaml instanceof Map) {
            return this.simplifyMap((Map)yaml);
        }
        if (yaml instanceof List) {
            return this.simplifyList((List)yaml);
        }
        if (yaml instanceof Date) {
            return DateTimeFormatter.ISO_OFFSET_DATE_TIME.withZone(ZoneOffset.UTC).format(((Date)yaml).toInstant());
        }
        return String.valueOf(yaml);
    }

    @NonNull
    protected Map<String, Object> simplifyMap(@NonNull Map<Object, Object> yaml) {
        if (yaml == null) {
            throw new NullPointerException("yaml is marked @NonNull but is null");
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(yaml.size());
        yaml.forEach((k, v) -> {
            String keyStr = String.valueOf(k);
            if (result.containsKey(keyStr)) {
                throw new IllegalArgumentException("by stringifying map keys we got a key conflict with: " + keyStr);
            }
            result.put(keyStr, this.simplify(v));
        });
        return result;
    }

    @NonNull
    protected Map<String, Object> simplifyList(@NonNull List<Object> yaml) {
        if (yaml == null) {
            throw new NullPointerException("yaml is marked @NonNull but is null");
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(yaml.size());
        ListIterator<Object> iterator = yaml.listIterator();
        while (iterator.hasNext()) {
            int index = iterator.nextIndex();
            Object simpleValue = this.simplify(iterator.next());
            result.put(String.valueOf(index), simpleValue);
        }
        return result;
    }

    public boolean canHandle(URI path) {
        return path.getSchemeSpecificPart().matches("(?i).+\\.ya?ml$");
    }
}

