/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.resource;

import ch.kk7.confij.common.Util;
import ch.kk7.confij.logging.ConfijLogger;
import ch.kk7.confij.source.ConfijSourceException;
import ch.kk7.confij.source.resource.AbstractResourceProvider;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.eclipse.jgit.treewalk.TreeWalk;

public class GitResourceProvider
extends AbstractResourceProvider {
    protected static final String TEMP_DIR_PREFIX = "confij-";
    protected static final Path TEMP_DIR = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    private static final ConfijLogger LOGGER = ConfijLogger.getLogger(GitResourceProvider.class);
    private static final String SCHEME = "git";
    private static final Pattern URL_FILE_SPLITTER = Pattern.compile("^(?<url>.+(?:\\.git/?|[^:]/))/(?<file>.+)$");
    private static final String FETCH_REFSPEC = "+refs/*:refs/*";

    public static URI toUri(String remoteUri, String configFile) {
        return GitResourceProvider.toUri(remoteUri, configFile, null);
    }

    public static URI toUri(@NonNull String remoteUri, @NonNull String configFile, String gitRevision) {
        if (remoteUri == null) {
            throw new NullPointerException("remoteUri is marked non-null but is null");
        }
        if (configFile == null) {
            throw new NullPointerException("configFile is marked non-null but is null");
        }
        configFile = configFile.startsWith("/") ? configFile.substring(1) : configFile;
        String urlFileSep = remoteUri.matches(".*\\.git/?$") ? "/" : "//";
        return URI.create("git:" + remoteUri + urlFileSep + configFile + (gitRevision == null ? "" : "#" + gitRevision));
    }

    public String read(URI path) {
        GitSettings settings = this.uriToGitSettings(path);
        Git git = this.gitCloneOrFetch(settings);
        return this.readFile(git, settings);
    }

    public boolean canHandle(URI path) {
        return SCHEME.equals(path.getScheme());
    }

    protected GitSettings uriToGitSettings(URI uri) {
        String urlAndFile = uri.getSchemeSpecificPart();
        Matcher m = URL_FILE_SPLITTER.matcher(urlAndFile);
        if (!m.matches()) {
            throw new ConfijSourceException("expected the git source to have a format like 'git:https://example.com/repo.git/path/to/file.yaml' (repo ending in '.git') or 'git:/var/opt/dir//path/to/file.yaml' (repo separated from file by double slash). However the provided '{}' does not match: {}", new Object[]{urlAndFile, URL_FILE_SPLITTER.pattern()});
        }
        String remoteUrl = m.group("url");
        String configFile = m.group("file");
        return GitSettings.builder().gitRevision(Optional.ofNullable(uri.getFragment()).filter(Util.not(String::isEmpty)).orElse("HEAD")).remoteUrl(remoteUrl).configFile(configFile).localDir(this.getFileForSeed(remoteUrl)).credentialsProvider(this.getCredentialsProvider(remoteUrl)).build();
    }

    protected CredentialsProvider getCredentialsProvider(String remoteUrl) {
        URIish urIish;
        try {
            urIish = new URIish(remoteUrl);
        }
        catch (URISyntaxException e) {
            throw new ConfijSourceException("not URIish: " + remoteUrl, new Object[]{e});
        }
        if (urIish.getUser() != null) {
            return new UsernamePasswordCredentialsProvider(urIish.getUser(), Optional.ofNullable(urIish.getPass()).orElse(""));
        }
        return null;
    }

    protected File getFileForSeed(@NonNull String seed) {
        if (seed == null) {
            throw new NullPointerException("seed is marked non-null but is null");
        }
        String name = UUID.nameUUIDFromBytes(seed.getBytes()).toString().replace("-", "");
        return TEMP_DIR.resolve(TEMP_DIR_PREFIX + name + ".git").toFile();
    }

    protected Git gitCloneOrFetch(GitSettings settings) {
        Git git = null;
        try {
            git = Git.open((File)settings.getLocalDir());
        }
        catch (RepositoryNotFoundException repositoryNotFoundException) {
        }
        catch (IOException e) {
            throw new ConfijSourceException("failed to check git repository with {}", new Object[]{settings, e});
        }
        try {
            if (git == null) {
                return this.gitClone(settings);
            }
            return this.gitFetch(git, settings);
        }
        catch (IOException | GitAPIException | JGitInternalException e) {
            throw new ConfijSourceException("failed to open and fetch git repository with {}", new Object[]{settings, e});
        }
    }

    protected Git gitFetch(Git git, GitSettings settings) throws GitAPIException, IOException {
        LOGGER.debug("git fetch: {}", new Object[]{settings});
        FetchResult fetchResult = ((FetchCommand)((FetchCommand)((FetchCommand)git.fetch().setRemote(settings.getRemoteUrl()).setRefSpecs(new String[]{FETCH_REFSPEC}).setRemoveDeletedRefs(true).setCheckFetchedObjects(true).setCredentialsProvider(settings.getCredentialsProvider())).setTimeout(settings.getTimeoutInSeconds())).setTransportConfigCallback(settings.getTransportConfigCallback())).call();
        LOGGER.info("git fetch result: {}", new Object[]{fetchResult.getTrackingRefUpdates()});
        return git;
    }

    protected Git gitClone(GitSettings settings) throws GitAPIException, IOException {
        Git git = this.gitInit(settings);
        return this.gitFetch(git, settings);
    }

    protected Git gitInit(GitSettings settings) throws GitAPIException, IOException {
        LOGGER.debug("initializing a new git repository: {}", new Object[]{settings});
        Git git = Git.init().setDirectory(settings.getLocalDir()).setBare(true).call();
        StoredConfig config = git.getRepository().getConfig();
        config.setString("remote", "origin", "url", settings.getRemoteUrl());
        config.setString("remote", "origin", "fetch", FETCH_REFSPEC);
        config.save();
        return git;
    }

    protected RevCommit getRevCommit(Git git, GitSettings settings) {
        ObjectId objectId;
        Repository repository = git.getRepository();
        try {
            objectId = repository.resolve(settings.getGitRevision());
        }
        catch (Exception e) {
            throw new ConfijSourceException("failed to git resove revision {} ({})", new Object[]{settings.getGitRevision(), settings, e});
        }
        if (objectId == null) {
            throw new ConfijSourceException("unable to git resove revision {} ({})", new Object[]{settings.getGitRevision(), settings});
        }
        try {
            return repository.parseCommit((AnyObjectId)objectId);
        }
        catch (IOException e) {
            throw new ConfijSourceException("git failed to find commit for objectId {} ({})", new Object[]{objectId, settings, e});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String readFile(Git git, GitSettings settings) {
        RevCommit revCommit = this.getRevCommit(git, settings);
        try (TreeWalk walk = TreeWalk.forPath((Repository)git.getRepository(), (String)settings.getConfigFile(), (RevTree)revCommit.getTree());){
            if (walk != null) {
                byte[] bytes = git.getRepository().open((AnyObjectId)walk.getObjectId(0)).getBytes();
                String string = new String(bytes, this.getCharset());
                return string;
            }
            throw new ConfijSourceException("File {} not found within git repo at commit {}", new Object[]{settings.getConfigFile(), revCommit});
        }
        catch (IOException e) {
            throw new ConfijSourceException("failed to read file {} within git repo at commit {}", new Object[]{settings.getConfigFile(), revCommit, e});
        }
    }

    @Generated
    public String toString() {
        return "GitResourceProvider()";
    }

    public static class GitSettings {
        @NonNull
        private final String gitRevision;
        @NonNull
        private final String remoteUrl;
        @NonNull
        private final File localDir;
        @NonNull
        private final String configFile;
        private final CredentialsProvider credentialsProvider;
        private final int timeoutInSeconds;
        private final TransportConfigCallback transportConfigCallback;

        @Generated
        GitSettings(@NonNull String gitRevision, @NonNull String remoteUrl, @NonNull File localDir, @NonNull String configFile, CredentialsProvider credentialsProvider, int timeoutInSeconds, TransportConfigCallback transportConfigCallback) {
            if (gitRevision == null) {
                throw new NullPointerException("gitRevision is marked non-null but is null");
            }
            if (remoteUrl == null) {
                throw new NullPointerException("remoteUrl is marked non-null but is null");
            }
            if (localDir == null) {
                throw new NullPointerException("localDir is marked non-null but is null");
            }
            if (configFile == null) {
                throw new NullPointerException("configFile is marked non-null but is null");
            }
            this.gitRevision = gitRevision;
            this.remoteUrl = remoteUrl;
            this.localDir = localDir;
            this.configFile = configFile;
            this.credentialsProvider = credentialsProvider;
            this.timeoutInSeconds = timeoutInSeconds;
            this.transportConfigCallback = transportConfigCallback;
        }

        @Generated
        public static GitSettingsBuilder builder() {
            return new GitSettingsBuilder();
        }

        @NonNull
        @Generated
        public String getGitRevision() {
            return this.gitRevision;
        }

        @NonNull
        @Generated
        public String getRemoteUrl() {
            return this.remoteUrl;
        }

        @NonNull
        @Generated
        public File getLocalDir() {
            return this.localDir;
        }

        @NonNull
        @Generated
        public String getConfigFile() {
            return this.configFile;
        }

        @Generated
        public CredentialsProvider getCredentialsProvider() {
            return this.credentialsProvider;
        }

        @Generated
        public int getTimeoutInSeconds() {
            return this.timeoutInSeconds;
        }

        @Generated
        public TransportConfigCallback getTransportConfigCallback() {
            return this.transportConfigCallback;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GitSettings)) {
                return false;
            }
            GitSettings other = (GitSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$gitRevision = this.getGitRevision();
            String other$gitRevision = other.getGitRevision();
            if (this$gitRevision == null ? other$gitRevision != null : !this$gitRevision.equals(other$gitRevision)) {
                return false;
            }
            String this$remoteUrl = this.getRemoteUrl();
            String other$remoteUrl = other.getRemoteUrl();
            if (this$remoteUrl == null ? other$remoteUrl != null : !this$remoteUrl.equals(other$remoteUrl)) {
                return false;
            }
            File this$localDir = this.getLocalDir();
            File other$localDir = other.getLocalDir();
            if (this$localDir == null ? other$localDir != null : !((Object)this$localDir).equals(other$localDir)) {
                return false;
            }
            String this$configFile = this.getConfigFile();
            String other$configFile = other.getConfigFile();
            if (this$configFile == null ? other$configFile != null : !this$configFile.equals(other$configFile)) {
                return false;
            }
            CredentialsProvider this$credentialsProvider = this.getCredentialsProvider();
            CredentialsProvider other$credentialsProvider = other.getCredentialsProvider();
            if (this$credentialsProvider == null ? other$credentialsProvider != null : !this$credentialsProvider.equals(other$credentialsProvider)) {
                return false;
            }
            if (this.getTimeoutInSeconds() != other.getTimeoutInSeconds()) {
                return false;
            }
            TransportConfigCallback this$transportConfigCallback = this.getTransportConfigCallback();
            TransportConfigCallback other$transportConfigCallback = other.getTransportConfigCallback();
            return !(this$transportConfigCallback == null ? other$transportConfigCallback != null : !this$transportConfigCallback.equals(other$transportConfigCallback));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GitSettings;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $gitRevision = this.getGitRevision();
            result = result * 59 + ($gitRevision == null ? 43 : $gitRevision.hashCode());
            String $remoteUrl = this.getRemoteUrl();
            result = result * 59 + ($remoteUrl == null ? 43 : $remoteUrl.hashCode());
            File $localDir = this.getLocalDir();
            result = result * 59 + ($localDir == null ? 43 : ((Object)$localDir).hashCode());
            String $configFile = this.getConfigFile();
            result = result * 59 + ($configFile == null ? 43 : $configFile.hashCode());
            CredentialsProvider $credentialsProvider = this.getCredentialsProvider();
            result = result * 59 + ($credentialsProvider == null ? 43 : $credentialsProvider.hashCode());
            result = result * 59 + this.getTimeoutInSeconds();
            TransportConfigCallback $transportConfigCallback = this.getTransportConfigCallback();
            result = result * 59 + ($transportConfigCallback == null ? 43 : $transportConfigCallback.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GitResourceProvider.GitSettings(gitRevision=" + this.getGitRevision() + ", remoteUrl=" + this.getRemoteUrl() + ", localDir=" + this.getLocalDir() + ", configFile=" + this.getConfigFile() + ", credentialsProvider=" + this.getCredentialsProvider() + ", timeoutInSeconds=" + this.getTimeoutInSeconds() + ", transportConfigCallback=" + this.getTransportConfigCallback() + ")";
        }

        @Generated
        public GitSettings withGitRevision(@NonNull String gitRevision) {
            if (gitRevision == null) {
                throw new NullPointerException("gitRevision is marked non-null but is null");
            }
            return this.gitRevision == gitRevision ? this : new GitSettings(gitRevision, this.remoteUrl, this.localDir, this.configFile, this.credentialsProvider, this.timeoutInSeconds, this.transportConfigCallback);
        }

        @Generated
        public GitSettings withRemoteUrl(@NonNull String remoteUrl) {
            if (remoteUrl == null) {
                throw new NullPointerException("remoteUrl is marked non-null but is null");
            }
            return this.remoteUrl == remoteUrl ? this : new GitSettings(this.gitRevision, remoteUrl, this.localDir, this.configFile, this.credentialsProvider, this.timeoutInSeconds, this.transportConfigCallback);
        }

        @Generated
        public GitSettings withLocalDir(@NonNull File localDir) {
            if (localDir == null) {
                throw new NullPointerException("localDir is marked non-null but is null");
            }
            return this.localDir == localDir ? this : new GitSettings(this.gitRevision, this.remoteUrl, localDir, this.configFile, this.credentialsProvider, this.timeoutInSeconds, this.transportConfigCallback);
        }

        @Generated
        public GitSettings withConfigFile(@NonNull String configFile) {
            if (configFile == null) {
                throw new NullPointerException("configFile is marked non-null but is null");
            }
            return this.configFile == configFile ? this : new GitSettings(this.gitRevision, this.remoteUrl, this.localDir, configFile, this.credentialsProvider, this.timeoutInSeconds, this.transportConfigCallback);
        }

        @Generated
        public GitSettings withCredentialsProvider(CredentialsProvider credentialsProvider) {
            return this.credentialsProvider == credentialsProvider ? this : new GitSettings(this.gitRevision, this.remoteUrl, this.localDir, this.configFile, credentialsProvider, this.timeoutInSeconds, this.transportConfigCallback);
        }

        @Generated
        public GitSettings withTimeoutInSeconds(int timeoutInSeconds) {
            return this.timeoutInSeconds == timeoutInSeconds ? this : new GitSettings(this.gitRevision, this.remoteUrl, this.localDir, this.configFile, this.credentialsProvider, timeoutInSeconds, this.transportConfigCallback);
        }

        @Generated
        public GitSettings withTransportConfigCallback(TransportConfigCallback transportConfigCallback) {
            return this.transportConfigCallback == transportConfigCallback ? this : new GitSettings(this.gitRevision, this.remoteUrl, this.localDir, this.configFile, this.credentialsProvider, this.timeoutInSeconds, transportConfigCallback);
        }

        @Generated
        public static class GitSettingsBuilder {
            @Generated
            private String gitRevision;
            @Generated
            private String remoteUrl;
            @Generated
            private File localDir;
            @Generated
            private String configFile;
            @Generated
            private CredentialsProvider credentialsProvider;
            @Generated
            private int timeoutInSeconds;
            @Generated
            private TransportConfigCallback transportConfigCallback;

            @Generated
            GitSettingsBuilder() {
            }

            @Generated
            public GitSettingsBuilder gitRevision(@NonNull String gitRevision) {
                if (gitRevision == null) {
                    throw new NullPointerException("gitRevision is marked non-null but is null");
                }
                this.gitRevision = gitRevision;
                return this;
            }

            @Generated
            public GitSettingsBuilder remoteUrl(@NonNull String remoteUrl) {
                if (remoteUrl == null) {
                    throw new NullPointerException("remoteUrl is marked non-null but is null");
                }
                this.remoteUrl = remoteUrl;
                return this;
            }

            @Generated
            public GitSettingsBuilder localDir(@NonNull File localDir) {
                if (localDir == null) {
                    throw new NullPointerException("localDir is marked non-null but is null");
                }
                this.localDir = localDir;
                return this;
            }

            @Generated
            public GitSettingsBuilder configFile(@NonNull String configFile) {
                if (configFile == null) {
                    throw new NullPointerException("configFile is marked non-null but is null");
                }
                this.configFile = configFile;
                return this;
            }

            @Generated
            public GitSettingsBuilder credentialsProvider(CredentialsProvider credentialsProvider) {
                this.credentialsProvider = credentialsProvider;
                return this;
            }

            @Generated
            public GitSettingsBuilder timeoutInSeconds(int timeoutInSeconds) {
                this.timeoutInSeconds = timeoutInSeconds;
                return this;
            }

            @Generated
            public GitSettingsBuilder transportConfigCallback(TransportConfigCallback transportConfigCallback) {
                this.transportConfigCallback = transportConfigCallback;
                return this;
            }

            @Generated
            public GitSettings build() {
                return new GitSettings(this.gitRevision, this.remoteUrl, this.localDir, this.configFile, this.credentialsProvider, this.timeoutInSeconds, this.transportConfigCallback);
            }

            @Generated
            public String toString() {
                return "GitResourceProvider.GitSettings.GitSettingsBuilder(gitRevision=" + this.gitRevision + ", remoteUrl=" + this.remoteUrl + ", localDir=" + this.localDir + ", configFile=" + this.configFile + ", credentialsProvider=" + this.credentialsProvider + ", timeoutInSeconds=" + this.timeoutInSeconds + ", transportConfigCallback=" + this.transportConfigCallback + ")";
            }
        }
    }
}

