/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.validation;

import ch.kk7.confij.binding.BindingResult;
import ch.kk7.confij.common.ConfijException;
import ch.kk7.confij.tree.ConfijNode;
import ch.kk7.confij.tree.NodeDefinition;
import ch.kk7.confij.validation.ConfijValidationException;
import ch.kk7.confij.validation.ConfijValidator;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public class NonNullValidator<T>
implements ConfijValidator<T> {
    private final Set<String> nullableNames = Stream.of(Nullable.class.getSimpleName(), "Null").map(String::toLowerCase).collect(Collectors.toSet());
    private final Set<String> notNullableNames = Stream.of(NotNull.class.getSimpleName(), "NonNull").map(String::toLowerCase).collect(Collectors.toSet());
    private final boolean rootIsNullable;

    public static <T> NonNullValidator<T> initiallyNullable() {
        return new NonNullValidator<T>(true);
    }

    public static <T> NonNullValidator<T> initiallyNotNull() {
        return new NonNullValidator<T>(false);
    }

    protected static boolean hasAnnotationAsIn(NodeDefinition nodeDefinition, Set<String> listToCheck) {
        AnnotatedElement element = nodeDefinition.getNodeBindingContext().getAnnotatedElement();
        if (element == null) {
            return false;
        }
        return Arrays.stream(element.getDeclaredAnnotations()).map(x -> x.annotationType().getSimpleName().toLowerCase()).anyMatch(listToCheck::contains);
    }

    @Override
    public void validate(BindingResult<T> bindingResult) {
        this.validateNode(bindingResult, this.rootIsNullable);
    }

    protected boolean isNullableWithHistory(BindingResult<?> bindingResult, boolean defaultIsNullable) {
        NodeDefinition nodeDefinition = bindingResult.getNode().getConfig();
        if (this.isNullable(nodeDefinition)) {
            if (this.isNonNullable(nodeDefinition)) {
                throw new ConfijException("conflicting annotations on {}: {}, as it matches both {} and {}", bindingResult.getNode(), nodeDefinition.getNodeBindingContext().getAnnotatedElement(), this.getNullableNames(), this.getNotNullableNames());
            }
            return true;
        }
        if (this.isNonNullable(nodeDefinition)) {
            return false;
        }
        return defaultIsNullable;
    }

    protected void validateNode(BindingResult<?> bindingResult, boolean defaultIsNullable) {
        boolean isNullable = this.isNullableWithHistory(bindingResult, defaultIsNullable);
        ConfijNode node = bindingResult.getNode();
        if (!isNullable && node.getConfig().isValueHolder() && bindingResult.getValue() == null) {
            throw new ConfijValidationException("unexpected null-value at {}", node.getUri());
        }
        for (BindingResult<?> child : bindingResult.getChildren()) {
            this.validateNode(child, isNullable);
        }
    }

    protected boolean isNonNullable(NodeDefinition nodeDefinition) {
        return NonNullValidator.hasAnnotationAsIn(nodeDefinition, this.getNotNullableNames());
    }

    protected boolean isNullable(NodeDefinition nodeDefinition) {
        return NonNullValidator.hasAnnotationAsIn(nodeDefinition, this.getNullableNames());
    }

    @Generated
    public NonNullValidator(boolean rootIsNullable) {
        this.rootIsNullable = rootIsNullable;
    }

    @Generated
    public Set<String> getNullableNames() {
        return this.nullableNames;
    }

    @Generated
    public Set<String> getNotNullableNames() {
        return this.notNullableNames;
    }

    @Generated
    public boolean isRootIsNullable() {
        return this.rootIsNullable;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NonNullValidator)) {
            return false;
        }
        NonNullValidator other = (NonNullValidator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$nullableNames = this.getNullableNames();
        Set<String> other$nullableNames = other.getNullableNames();
        if (this$nullableNames == null ? other$nullableNames != null : !((Object)this$nullableNames).equals(other$nullableNames)) {
            return false;
        }
        Set<String> this$notNullableNames = this.getNotNullableNames();
        Set<String> other$notNullableNames = other.getNotNullableNames();
        if (this$notNullableNames == null ? other$notNullableNames != null : !((Object)this$notNullableNames).equals(other$notNullableNames)) {
            return false;
        }
        return this.isRootIsNullable() == other.isRootIsNullable();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NonNullValidator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $nullableNames = this.getNullableNames();
        result = result * 59 + ($nullableNames == null ? 43 : ((Object)$nullableNames).hashCode());
        Set<String> $notNullableNames = this.getNotNullableNames();
        result = result * 59 + ($notNullableNames == null ? 43 : ((Object)$notNullableNames).hashCode());
        result = result * 59 + (this.isRootIsNullable() ? 79 : 97);
        return result;
    }

    @Generated
    public String toString() {
        return "NonNullValidator(nullableNames=" + this.getNullableNames() + ", notNullableNames=" + this.getNotNullableNames() + ", rootIsNullable=" + this.isRootIsNullable() + ")";
    }

    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface NotNull {
    }

    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    public static @interface Nullable {
    }
}

