/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.resource;

import ch.kk7.confij.source.ConfijSourceBuilder;
import ch.kk7.confij.source.resource.AbstractResourceProvider;
import ch.kk7.confij.source.resource.ConfijResourceProvider;
import ch.kk7.confij.source.resource.ConfijSourceFetchingException;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Scanner;
import java.util.stream.Stream;
import lombok.Generated;

@AutoService(value={ConfijResourceProvider.class})
public class URLResourceProvider
extends AbstractResourceProvider {
    @Override
    public Stream<String> read(ConfijSourceBuilder.URIish path) {
        try {
            return Stream.of(this.read(path.toURL()));
        }
        catch (MalformedURLException e) {
            throw ConfijSourceFetchingException.unableToFetch(path.toString(), "not a valid URL", e);
        }
    }

    String read(URL url) {
        String string;
        block8: {
            InputStream inputStream = url.openStream();
            try {
                Scanner s = new Scanner(inputStream, this.getCharset().name()).useDelimiter("\\A");
                String string2 = string = s.hasNext() ? s.next() : "";
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw ConfijSourceFetchingException.unableToFetch(url.toString(), "cannot read", e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    @Override
    public boolean canHandle(ConfijSourceBuilder.URIish path) {
        try {
            path.toURL();
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    @Override
    @Generated
    public String toString() {
        return "URLResourceProvider()";
    }
}

