/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.resource;

import ch.kk7.confij.logging.ConfijLogger;
import ch.kk7.confij.source.ConfijSourceBuilder;
import ch.kk7.confij.source.resource.ConfijResourceProvider;
import ch.kk7.confij.source.resource.ConfijSourceFetchingException;
import ch.kk7.confij.source.resource.URLResourceProvider;
import com.google.auto.service.AutoService;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

@AutoService(value={ConfijResourceProvider.class})
public class FileResourceProvider
extends URLResourceProvider {
    public static final String SCHEME = "file";
    private static final ConfijLogger LOGGER = ConfijLogger.getLogger(FileResourceProvider.class);
    int maxFileMatches = 50;
    int maxFilesTraversed = 10000;
    Pattern globPattern = Pattern.compile("(^|.*[^\\\\])([*?]|\\[.+]|\\{.+}).*");

    protected List<Path> getFilesMatching(final @NonNull PathAndMatcher query) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        final ArrayList<Path> matchingFiles = new ArrayList<Path>();
        final int[] fileCounter = new int[]{0};
        Files.walkFileTree(query.getBasePath(), EnumSet.noneOf(FileVisitOption.class), query.getMaxDepth(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                if (query.getPathMatcher().matches(file)) {
                    if (matchingFiles.size() >= FileResourceProvider.this.maxFileMatches) {
                        throw new ConfijSourceFetchingException("found too many files (>={}) matching glob expression. your expression '{}' seems too lax. if this was intentional, try to increase '{}'", FileResourceProvider.this.maxFileMatches, query.getOriginalPath(), "maxFileMatches");
                    }
                    fileCounter[0] = fileCounter[0] + 1;
                    if (fileCounter[0] >= FileResourceProvider.this.maxFilesTraversed) {
                        throw new ConfijSourceFetchingException("traversed too many files (>={}) in query of a maching glob expression. your expression '{}' seems too expensive. if this was intentional, try to increase '{}'", fileCounter[0], query.getOriginalPath(), "maxFilesTraversed");
                    }
                    matchingFiles.add(file);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        LOGGER.debug("traversed {} files to find {} files matching glob '{}'", fileCounter[0], matchingFiles.size(), query.getOriginalPath());
        matchingFiles.sort(Comparator.comparingInt(Path::getNameCount).thenComparing(Comparator.naturalOrder()));
        return matchingFiles;
    }

    protected PathAndMatcher extractGlob(String path) {
        String[] parts = path.split("/", -1);
        int globAt = -1;
        int maxDepth = -1;
        for (int i = 0; i < parts.length; ++i) {
            if (globAt == -1 && this.globPattern.matcher(parts[i]).matches()) {
                globAt = i;
                maxDepth = 0;
            }
            if (globAt == -1) continue;
            if (parts[i].contains("**")) {
                maxDepth = Integer.MAX_VALUE;
                break;
            }
            ++maxDepth;
        }
        if (globAt == -1) {
            return new PathAndMatcher(Paths.get(path, new String[0]), null, path, -1);
        }
        String beforeGlob = Stream.of(parts).limit(globAt).collect(Collectors.joining("/"));
        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + path);
        return new PathAndMatcher(Paths.get(beforeGlob, new String[0]), pathMatcher, path, maxDepth);
    }

    protected String read(Path path) {
        URL url;
        try {
            url = path.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw ConfijSourceFetchingException.unableToFetch(path.toAbsolutePath().toString(), "not a valid URL", e);
        }
        return this.read(url);
    }

    @Override
    public Stream<String> read(ConfijSourceBuilder.URIish fileUri) {
        String path = fileUri.getSchemeSpecificPart();
        PathAndMatcher query = this.extractGlob(path);
        List<Path> matchingFiles = query.getPathMatcher() == null ? Collections.singletonList(query.getBasePath()) : this.getFilesMatching(query);
        return matchingFiles.stream().map(this::read);
    }

    @Override
    public boolean canHandle(ConfijSourceBuilder.URIish path) {
        return path.getScheme() == null || SCHEME.equals(path.getScheme());
    }

    @Override
    @Generated
    public String toString() {
        return "FileResourceProvider(maxFileMatches=" + this.maxFileMatches + ", maxFilesTraversed=" + this.maxFilesTraversed + ", globPattern=" + this.globPattern + ")";
    }

    @Generated
    public void setMaxFileMatches(int maxFileMatches) {
        this.maxFileMatches = maxFileMatches;
    }

    @Generated
    public void setMaxFilesTraversed(int maxFilesTraversed) {
        this.maxFilesTraversed = maxFilesTraversed;
    }

    @Generated
    public void setGlobPattern(Pattern globPattern) {
        this.globPattern = globPattern;
    }

    @Generated
    public static final class Fields {
        public static final String maxFileMatches = "maxFileMatches";
        public static final String maxFilesTraversed = "maxFilesTraversed";
        public static final String globPattern = "globPattern";
    }

    protected static class PathAndMatcher {
        private final Path basePath;
        private final PathMatcher pathMatcher;
        private final String originalPath;
        private final int maxDepth;

        @Generated
        public PathAndMatcher(Path basePath, PathMatcher pathMatcher, String originalPath, int maxDepth) {
            this.basePath = basePath;
            this.pathMatcher = pathMatcher;
            this.originalPath = originalPath;
            this.maxDepth = maxDepth;
        }

        @Generated
        public Path getBasePath() {
            return this.basePath;
        }

        @Generated
        public PathMatcher getPathMatcher() {
            return this.pathMatcher;
        }

        @Generated
        public String getOriginalPath() {
            return this.originalPath;
        }

        @Generated
        public int getMaxDepth() {
            return this.maxDepth;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PathAndMatcher)) {
                return false;
            }
            PathAndMatcher other = (PathAndMatcher)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Path this$basePath = this.getBasePath();
            Path other$basePath = other.getBasePath();
            if (this$basePath == null ? other$basePath != null : !((Object)this$basePath).equals(other$basePath)) {
                return false;
            }
            PathMatcher this$pathMatcher = this.getPathMatcher();
            PathMatcher other$pathMatcher = other.getPathMatcher();
            if (this$pathMatcher == null ? other$pathMatcher != null : !this$pathMatcher.equals(other$pathMatcher)) {
                return false;
            }
            String this$originalPath = this.getOriginalPath();
            String other$originalPath = other.getOriginalPath();
            if (this$originalPath == null ? other$originalPath != null : !this$originalPath.equals(other$originalPath)) {
                return false;
            }
            return this.getMaxDepth() == other.getMaxDepth();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PathAndMatcher;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Path $basePath = this.getBasePath();
            result = result * 59 + ($basePath == null ? 43 : ((Object)$basePath).hashCode());
            PathMatcher $pathMatcher = this.getPathMatcher();
            result = result * 59 + ($pathMatcher == null ? 43 : $pathMatcher.hashCode());
            String $originalPath = this.getOriginalPath();
            result = result * 59 + ($originalPath == null ? 43 : $originalPath.hashCode());
            result = result * 59 + this.getMaxDepth();
            return result;
        }

        @Generated
        public String toString() {
            return "FileResourceProvider.PathAndMatcher(basePath=" + this.getBasePath() + ", pathMatcher=" + this.getPathMatcher() + ", originalPath=" + this.getOriginalPath() + ", maxDepth=" + this.getMaxDepth() + ")";
        }
    }
}

