/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.resource;

import ch.kk7.confij.source.ConfijSourceBuilder;
import ch.kk7.confij.source.resource.ConfijResourceProvider;
import ch.kk7.confij.source.resource.ConfijSourceFetchingException;
import ch.kk7.confij.source.resource.URLResourceProvider;
import com.google.auto.service.AutoService;
import java.net.URL;
import java.util.stream.Stream;
import lombok.Generated;

@AutoService(value={ConfijResourceProvider.class})
public class ClasspathResourceProvider
extends URLResourceProvider {
    public static final String SCHEME = "classpath";

    @Override
    public Stream<String> read(ConfijSourceBuilder.URIish path) {
        URL classpathUrl = ClassLoader.getSystemResource(path.getSchemeSpecificPart());
        if (classpathUrl == null) {
            throw ConfijSourceFetchingException.unableToFetch(path.getSchemeSpecificPart(), "no such file on system classpath", new Object[0]);
        }
        return Stream.of(this.read(classpathUrl));
    }

    @Override
    public boolean canHandle(ConfijSourceBuilder.URIish path) {
        return SCHEME.equals(path.getScheme());
    }

    @Override
    @Generated
    public String toString() {
        return "ClasspathResourceProvider()";
    }
}

