/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.format;

import ch.kk7.confij.source.ConfijSourceBuilder;
import ch.kk7.confij.source.format.ConfijSourceFormat;
import ch.kk7.confij.source.format.ConfijSourceFormatException;
import ch.kk7.confij.source.format.MapAndStringValidator;
import ch.kk7.confij.tree.ConfijNode;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

@AutoService(value={ConfijSourceFormat.class})
public class PropertiesFormat
implements ConfijSourceFormat {
    private static final Pattern BRACKETS_ARRAY_FORMAT = Pattern.compile("(\\S+)\\[(\\d+)]");
    @NonNull
    private String separator = ".";
    private String globalPrefix = null;

    @Override
    public void override(ConfijNode rootNode, String configAsStr) {
        Properties properties = new Properties();
        try (StringReader r = new StringReader(configAsStr);){
            properties.load(r);
        }
        catch (IOException e) {
            throw ConfijSourceFormatException.invalidFormat("properties", "cannot load from string", e);
        }
        this.overrideWithProperties(rootNode, properties);
    }

    protected void overrideWithProperties(ConfijNode simpleConfig, Properties properties) {
        this.overrideWithFlatMap(simpleConfig, properties);
    }

    protected void overrideWithFlatMap(ConfijNode simpleConfig, Map<String, String> map) {
        Object deepMap = this.flatToNestedMapWithPrefix(map);
        this.overrideWithDeepMap(simpleConfig, deepMap);
    }

    protected void overrideWithDeepMap(ConfijNode node, Object deepMap) {
        MapAndStringValidator.validateDefinition(deepMap, node);
        ConfijNode newConfig = ConfijNode.newRootFor(node.getConfig()).initializeFromMap(deepMap);
        node.overrideWith(newConfig);
    }

    protected Object flatToNestedMapWithPrefix(Map<String, String> globalMap) {
        return this.flatToNestedMap(this.flatmapPrefixedBy(globalMap, this.getGlobalPrefix()));
    }

    protected Map<String, String> flatmapPrefixedBy(@NonNull Map<String, String> map, String prefix) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        if (prefix == null) {
            return map;
        }
        String prefixAndSep = prefix + this.getSeparator();
        HashMap<String, String> result = new HashMap<String, String>();
        map.forEach((k, v) -> {
            if (k.startsWith(prefixAndSep)) {
                result.put(k.substring(prefixAndSep.length()), (String)v);
            }
        });
        return result;
    }

    @NonNull
    protected Object flatToNestedMap(@NonNull Map<String, String> map) {
        if (map == null) {
            throw new NullPointerException("map is marked non-null but is null");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String fullKey = entry.getKey();
            Map<String, Object> current = result;
            String[] keyParts = (String[])Arrays.stream(fullKey.split(Pattern.quote(this.getSeparator()), -1)).flatMap(currentKey -> {
                Matcher matcher = BRACKETS_ARRAY_FORMAT.matcher((CharSequence)currentKey);
                if (matcher.matches()) {
                    return Stream.of(matcher.group(1), matcher.group(2));
                }
                return Stream.of(currentKey);
            }).toArray(String[]::new);
            String keySoFar = null;
            for (int i = 0; i < keyParts.length - 1; ++i) {
                keySoFar = keySoFar == null ? keyParts[i] : keySoFar + this.getSeparator() + keyParts[i];
                Object child = current.computeIfAbsent(keyParts[i], s -> new HashMap());
                if (child instanceof String) {
                    throw this.keyConflict(fullKey, keySoFar);
                }
                current = (Map)child;
            }
            String lastKeyPart = keyParts[keyParts.length - 1];
            if (current.containsKey(lastKeyPart)) {
                throw this.keyConflict(fullKey, fullKey + this.getSeparator() + "*");
            }
            current.put(lastKeyPart, entry.getValue());
        }
        return result;
    }

    protected ConfijSourceFormatException keyConflict(String key1, String key2) {
        String prefixStr = this.getGlobalPrefix() == null ? "" : this.getGlobalPrefix() + this.getSeparator();
        return new ConfijSourceFormatException("key '{}' conflicts with key '{}'. each key must start with an unique string to map it into a config-tree structure.", prefixStr + key1, prefixStr + key2);
    }

    @Override
    public boolean canHandle(ConfijSourceBuilder.URIish path) {
        return path.getSchemeSpecificPart().matches("(?s).+\\.prop(ertie)?s?$");
    }

    @Generated
    public void setSeparator(@NonNull String separator) {
        if (separator == null) {
            throw new NullPointerException("separator is marked non-null but is null");
        }
        this.separator = separator;
    }

    @Generated
    public void setGlobalPrefix(String globalPrefix) {
        this.globalPrefix = globalPrefix;
    }

    @NonNull
    @Generated
    public String getSeparator() {
        return this.separator;
    }

    @Generated
    public String getGlobalPrefix() {
        return this.globalPrefix;
    }
}

