/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.format;

import ch.kk7.confij.binding.ConfijBindingException;
import ch.kk7.confij.tree.ConfijNode;
import ch.kk7.confij.tree.NodeDefinition;
import java.util.Map;
import lombok.Generated;

public final class MapAndStringValidator {
    private static final String SEP = ".";

    public static void validateDefinition(Object src, ConfijNode node) throws ConfijBindingException {
        MapAndStringValidator.validateObj(null, src, node.getConfig());
    }

    protected static void validateObj(String path, Object src, NodeDefinition definition) {
        if (src instanceof String || src == null) {
            MapAndStringValidator.validateDefinition(path, (String)src, definition);
        } else if (src instanceof Map) {
            MapAndStringValidator.validateDefinition(path, (Map)src, definition);
        } else {
            throw new IllegalArgumentException("expected an instance of String or Map at config path " + path + ", but got " + src);
        }
    }

    protected static void validateDefinition(String path, Map<String, Object> src, NodeDefinition definition) {
        for (Map.Entry<String, Object> entry : src.entrySet()) {
            NodeDefinition childDefinition;
            String childPath = (path == null ? "" : path + SEP) + entry.getKey();
            try {
                childDefinition = definition.definitionForChild(entry.getKey());
            }
            catch (ConfijBindingException e) {
                throw new ConfijBindingException("unexpected content at configuration path '{}' (value: {}): " + e.getMessage(), childPath, src, e);
            }
            MapAndStringValidator.validateObj(childPath, entry.getValue(), childDefinition);
        }
    }

    protected static void validateDefinition(String path, String src, NodeDefinition definition) {
        if (!definition.isValueHolder()) {
            throw new ConfijBindingException("unexpected leaf-value at key '{}' (value: {}). expected a Map instead. mandatory keys are {}", path == null ? SEP : path, src, definition.getMandatoryKeys());
        }
    }

    @Generated
    private MapAndStringValidator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

