/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.any;

import ch.kk7.confij.logging.ConfijLogger;
import ch.kk7.confij.source.ConfijSource;
import ch.kk7.confij.source.ConfijSourceBuilder;
import ch.kk7.confij.source.ConfijSourceException;
import ch.kk7.confij.source.format.ConfijSourceFormat;
import ch.kk7.confij.source.format.ConfijSourceFormatException;
import ch.kk7.confij.source.resource.ConfijResourceProvider;
import ch.kk7.confij.source.resource.ConfijSourceFetchingException;
import ch.kk7.confij.tree.ConfijNode;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;

public class FixedResourceSource
implements ConfijSource {
    private static final ConfijLogger LOGGER = ConfijLogger.getLogger(FixedResourceSource.class);
    @NonNull
    private final ConfijSourceBuilder.URIish path;
    @NonNull
    private final ConfijResourceProvider resource;
    @NonNull
    private final ConfijSourceFormat format;

    @Override
    public void override(ConfijNode rootNode) {
        Stream<String> configsAsStr;
        try {
            configsAsStr = this.resource.read(this.path);
        }
        catch (ConfijSourceException e) {
            throw new ConfijSourceFetchingException("failed to fetch raw configuration data from '{}' using {}", this.path, this.resource, e);
        }
        configsAsStr.forEach(configAsStr -> {
            try {
                this.format.override(rootNode, (String)configAsStr);
            }
            catch (ConfijSourceException e) {
                LOGGER.debug("processing configuration with {} failed. Source was: \n{}", this.format, configAsStr);
                throw new ConfijSourceFormatException("Sucessfully read a configuration in this pipeline step, but failed to apply it to the final configuration due to an invalid source format", new Object[]{e});
            }
        });
    }

    @Generated
    public FixedResourceSource(@NonNull ConfijSourceBuilder.URIish path, @NonNull ConfijResourceProvider resource, @NonNull ConfijSourceFormat format) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        if (format == null) {
            throw new NullPointerException("format is marked non-null but is null");
        }
        this.path = path;
        this.resource = resource;
        this.format = format;
    }

    @NonNull
    @Generated
    public ConfijSourceBuilder.URIish getPath() {
        return this.path;
    }

    @NonNull
    @Generated
    public ConfijResourceProvider getResource() {
        return this.resource;
    }

    @NonNull
    @Generated
    public ConfijSourceFormat getFormat() {
        return this.format;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FixedResourceSource)) {
            return false;
        }
        FixedResourceSource other = (FixedResourceSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConfijSourceBuilder.URIish this$path = this.getPath();
        ConfijSourceBuilder.URIish other$path = other.getPath();
        if (this$path == null ? other$path != null : !((Object)this$path).equals(other$path)) {
            return false;
        }
        ConfijResourceProvider this$resource = this.getResource();
        ConfijResourceProvider other$resource = other.getResource();
        if (this$resource == null ? other$resource != null : !this$resource.equals(other$resource)) {
            return false;
        }
        ConfijSourceFormat this$format = this.getFormat();
        ConfijSourceFormat other$format = other.getFormat();
        return !(this$format == null ? other$format != null : !this$format.equals(other$format));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FixedResourceSource;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConfijSourceBuilder.URIish $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        ConfijResourceProvider $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : $resource.hashCode());
        ConfijSourceFormat $format = this.getFormat();
        result = result * 59 + ($format == null ? 43 : $format.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FixedResourceSource(path=" + this.getPath() + ", resource=" + this.getResource() + ", format=" + this.getFormat() + ")";
    }
}

