/*
 * Decompiled with CFR 0.152.
 */
package ch.kk7.confij.source.any;

import ch.kk7.confij.common.ServiceLoaderUtil;
import ch.kk7.confij.source.ConfijSource;
import ch.kk7.confij.source.ConfijSourceBuilder;
import ch.kk7.confij.source.ConfijSourceException;
import ch.kk7.confij.template.ValueResolver;
import ch.kk7.confij.tree.ConfijNode;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class AnySource
implements ConfijSource {
    private final List<ConfijSourceBuilder> sourceBuilders;
    private final String pathTemplate;

    public AnySource(String pathTemplate) {
        this.pathTemplate = Objects.requireNonNull(pathTemplate);
        this.sourceBuilders = ServiceLoaderUtil.requireInstancesOf(ConfijSourceBuilder.class);
    }

    protected static ValueResolver getResolver(ConfijNode rootNode) {
        return rootNode.getConfig().getNodeBindingContext().getValueResolver();
    }

    protected ConfijSourceBuilder.URIish resolveUri(ConfijNode rootNode) {
        String actualPath = AnySource.getResolver(rootNode).resolveValue(rootNode, this.pathTemplate);
        return ConfijSourceBuilder.URIish.create(actualPath);
    }

    @Override
    public void override(ConfijNode rootNode) {
        ConfijSourceBuilder.URIish path = this.resolveUri(rootNode);
        ConfijSource confijSource = this.sourceBuilders.stream().map(sourceBulder -> sourceBulder.fromURI(path)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> {
            String addon = this.pathTemplate.equals(path.toString()) ? "" : " (resolved from '" + this.pathTemplate + "')";
            return new ConfijSourceException("The {} was unable to find a {} which can handle '{}'{}", this, ConfijSourceBuilder.class.getSimpleName(), path, addon);
        });
        try {
            confijSource.override(rootNode);
        }
        catch (ConfijSourceException e) {
            throw new ConfijSourceException("Failed reading source from path `{}` using {} (either fix the content of this source or write a new ServiceLoader implementing {}): {}", path, this, ConfijSource.class.getSimpleName(), e.getMessage(), e);
        }
    }

    @Generated
    public List<ConfijSourceBuilder> getSourceBuilders() {
        return this.sourceBuilders;
    }

    @Generated
    public String getPathTemplate() {
        return this.pathTemplate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnySource)) {
            return false;
        }
        AnySource other = (AnySource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ConfijSourceBuilder> this$sourceBuilders = this.getSourceBuilders();
        List<ConfijSourceBuilder> other$sourceBuilders = other.getSourceBuilders();
        if (this$sourceBuilders == null ? other$sourceBuilders != null : !((Object)this$sourceBuilders).equals(other$sourceBuilders)) {
            return false;
        }
        String this$pathTemplate = this.getPathTemplate();
        String other$pathTemplate = other.getPathTemplate();
        return !(this$pathTemplate == null ? other$pathTemplate != null : !this$pathTemplate.equals(other$pathTemplate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AnySource;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ConfijSourceBuilder> $sourceBuilders = this.getSourceBuilders();
        result = result * 59 + ($sourceBuilders == null ? 43 : ((Object)$sourceBuilders).hashCode());
        String $pathTemplate = this.getPathTemplate();
        result = result * 59 + ($pathTemplate == null ? 43 : $pathTemplate.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AnySource(pathTemplate=" + this.getPathTemplate() + ")";
    }
}

